/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.database.system.SystemDatabase;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.type.RawMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dal.ShowFilterSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtils;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowTablesStatement;

public final class ShowTablesExecutor
implements DatabaseAdminQueryExecutor {
    private static final String TABLE_TYPE = "BASE TABLE";
    private final MySQLShowTablesStatement showTablesStatement;
    private final DatabaseType databaseType;
    private QueryResultMetaData queryResultMetaData;
    private MergedResult mergedResult;

    public void execute(ConnectionSession connectionSession) {
        String databaseName = this.showTablesStatement.getFromSchema().map(schema -> schema.getSchema().getIdentifier().getValue()).orElseGet(() -> ((ConnectionSession)connectionSession).getDatabaseName());
        this.queryResultMetaData = this.createQueryResultMetaData(databaseName);
        this.mergedResult = new TransparentMergedResult(this.getQueryResult(databaseName));
    }

    private QueryResultMetaData createQueryResultMetaData(String databaseName) {
        LinkedList<RawQueryResultColumnMetaData> columnNames = new LinkedList<RawQueryResultColumnMetaData>();
        String tableColumnName = String.format("Tables_in_%s", databaseName);
        columnNames.add(new RawQueryResultColumnMetaData("", tableColumnName, tableColumnName, 12, "VARCHAR", 255, 0));
        if (this.showTablesStatement.isContainsFull()) {
            columnNames.add(new RawQueryResultColumnMetaData("", "Table_type", "Table_type", 12, "VARCHAR", 20, 0));
        }
        return new RawQueryResultMetaData(columnNames);
    }

    private QueryResult getQueryResult(String databaseName) {
        SystemDatabase systemDatabase = new SystemDatabase(this.databaseType);
        if (!systemDatabase.getSystemSchemas().contains(databaseName) && !ProxyContext.getInstance().getDatabase(databaseName).isComplete()) {
            return new RawMemoryQueryResult(this.queryResultMetaData, Collections.emptyList());
        }
        List rows = this.getAllTableNames(databaseName).stream().map(each -> {
            LinkedList<String> rowValues = new LinkedList<String>();
            rowValues.add((String)each);
            if (this.showTablesStatement.isContainsFull()) {
                rowValues.add(TABLE_TYPE);
            }
            return new MemoryQueryResultDataRow(rowValues);
        }).collect(Collectors.toList());
        return new RawMemoryQueryResult(this.queryResultMetaData, rows);
    }

    private Collection<String> getAllTableNames(String databaseName) {
        Collection result = ProxyContext.getInstance().getDatabase(databaseName).getSchema(databaseName).getTables().values().stream().map(ShardingSphereTable::getName).collect(Collectors.toList());
        if (!this.showTablesStatement.getFilter().isPresent()) {
            return result;
        }
        Optional<String> pattern = ((ShowFilterSegment)this.showTablesStatement.getFilter().get()).getLike().map(optional -> SQLUtils.convertLikePatternToRegex((String)optional.getPattern()));
        return pattern.isPresent() ? (Collection)result.stream().filter(each -> Pattern.compile((String)pattern.get(), 2).matcher((CharSequence)each).matches()).collect(Collectors.toList()) : result;
    }

    @Generated
    public ShowTablesExecutor(MySQLShowTablesStatement showTablesStatement, DatabaseType databaseType) {
        this.showTablesStatement = showTablesStatement;
        this.databaseType = databaseType;
    }

    @Generated
    public QueryResultMetaData getQueryResultMetaData() {
        return this.queryResultMetaData;
    }

    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }
}

