/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor;

import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataMergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class ShowConnectionIdExecutor
implements DatabaseAdminQueryExecutor {
    public static final String FUNCTION_NAME = "connection_id()";
    private final SelectStatement sqlStatement;
    private MergedResult mergedResult;

    public void execute(ConnectionSession connectionSession) {
        this.mergedResult = new LocalDataMergedResult(Collections.singleton(new LocalDataQueryResultRow(new Object[]{connectionSession.getConnectionId()})));
    }

    public QueryResultMetaData getQueryResultMetaData() {
        return new RawQueryResultMetaData(Collections.singletonList(new RawQueryResultColumnMetaData("", FUNCTION_NAME, this.getLabel(), 12, "VARCHAR", 100, 0)));
    }

    private String getLabel() {
        Collection projections = this.sqlStatement.getProjections().getProjections();
        for (ProjectionSegment each : projections) {
            if (!(each instanceof ExpressionProjectionSegment)) continue;
            return ((ExpressionProjectionSegment)each).getAliasName().orElse(FUNCTION_NAME);
        }
        return FUNCTION_NAME;
    }

    @Generated
    public ShowConnectionIdExecutor(SelectStatement sqlStatement) {
        this.sqlStatement = sqlStatement;
    }

    @Generated
    public SelectStatement getSqlStatement() {
        return this.sqlStatement;
    }

    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }
}

