/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.engine.ProjectionEngine;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.type.RawMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class NoResourceShowExecutor
implements DatabaseAdminQueryExecutor {
    private MergedResult mergedResult;
    private final SelectStatement sqlStatement;
    private Collection<Object> expressions = Collections.emptyList();

    public void execute(ConnectionSession connectionSession) {
        TableSegment tableSegment = this.sqlStatement.getFrom();
        this.expressions = this.sqlStatement.getProjections().getProjections().stream().filter(each -> !(each instanceof ShorthandProjectionSegment)).map(each -> new ProjectionEngine(null).createProjection(tableSegment, each)).filter(Optional::isPresent).map(each -> ((Projection)each.get()).getAlias().isPresent() ? ((Projection)each.get()).getAlias().get() : ((Projection)each.get()).getExpression()).collect(Collectors.toList());
        this.mergedResult = new TransparentMergedResult(this.getQueryResult());
    }

    private QueryResult getQueryResult() {
        LinkedList<MemoryQueryResultDataRow> rows = new LinkedList<MemoryQueryResultDataRow>();
        if (this.expressions.isEmpty()) {
            rows.add(new MemoryQueryResultDataRow(Collections.singletonList("")));
            return new RawMemoryQueryResult(this.getQueryResultMetaData(), rows);
        }
        ArrayList<Object> row = new ArrayList<Object>(this.expressions);
        Collections.fill(row, "");
        rows.add(new MemoryQueryResultDataRow(row));
        return new RawMemoryQueryResult(this.getQueryResultMetaData(), rows);
    }

    public QueryResultMetaData getQueryResultMetaData() {
        if (this.expressions.isEmpty()) {
            RawQueryResultColumnMetaData defaultColumnMetaData = new RawQueryResultColumnMetaData("", "", "", 12, "VARCHAR", 100, 0);
            return new RawQueryResultMetaData(Collections.singletonList(defaultColumnMetaData));
        }
        List columns = this.expressions.stream().map(each -> new RawQueryResultColumnMetaData("", each.toString(), each.toString(), 12, "VARCHAR", 100, 0)).collect(Collectors.toList());
        return new RawQueryResultMetaData(columns);
    }

    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }

    @Generated
    public SelectStatement getSqlStatement() {
        return this.sqlStatement;
    }

    @Generated
    public Collection<Object> getExpressions() {
        return this.expressions;
    }

    @Generated
    public NoResourceShowExecutor(SelectStatement sqlStatement) {
        this.sqlStatement = sqlStatement;
    }
}

