/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.SystemSchemaBuilderRule;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.AbstractDatabaseMetaDataExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.information.SelectInformationSchemataExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class MySQLInformationSchemaExecutorFactory {
    private static final String SCHEMATA_TABLE = "SCHEMATA";

    public static Optional<DatabaseAdminExecutor> newInstance(SelectStatement sqlStatement, String sql, List<Object> parameters) {
        if (!(sqlStatement.getFrom() instanceof SimpleTableSegment)) {
            return Optional.empty();
        }
        String tableName = ((SimpleTableSegment)sqlStatement.getFrom()).getTableName().getIdentifier().getValue();
        if (SCHEMATA_TABLE.equalsIgnoreCase(tableName)) {
            return Optional.of(new SelectInformationSchemataExecutor(sqlStatement, sql, parameters));
        }
        if (SystemSchemaBuilderRule.MYSQL_INFORMATION_SCHEMA.getTables().contains(tableName.toLowerCase())) {
            return Optional.of(new AbstractDatabaseMetaDataExecutor.DefaultDatabaseMetaDataExecutor(sql, parameters));
        }
        return Optional.empty();
    }

    @Generated
    private MySQLInformationSchemaExecutorFactory() {
    }
}

