/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.util;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;

public final class HBaseHeterogeneousUtils {
    public static boolean isCrcProjectionSegment(ProjectionSegment projectionSegment) {
        if (projectionSegment instanceof ExpressionProjectionSegment) {
            return ((ExpressionProjectionSegment)projectionSegment).getText().contains("crc32");
        }
        return false;
    }

    public static String replaceSQLStatementWithParameters(String source, CharSequence target, Object ... replacements) {
        if (null == source || null == replacements) {
            return source;
        }
        Matcher matcher = Pattern.compile(target.toString(), 16).matcher(source);
        int found = 0;
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            Preconditions.checkState((++found <= replacements.length ? 1 : 0) != 0, (String)"Missing replacement for '%s' at [%s].", (Object)target, (int)found);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacements[found - 1].toString()));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static boolean isUseShorthandProjection(SelectStatementContext statementContext) {
        return statementContext.getProjectionsContext().getProjections().stream().anyMatch(ShorthandProjection.class::isInstance);
    }

    @Generated
    private HBaseHeterogeneousUtils() {
    }
}

