/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.result.update;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.proxy.backend.hbase.bean.HBaseOperation;
import org.apache.shardingsphere.proxy.backend.hbase.context.HBaseContext;
import org.apache.shardingsphere.proxy.backend.hbase.context.HBaseRegionWarmUpContext;
import org.apache.shardingsphere.proxy.backend.hbase.exception.HBaseOperationException;
import org.apache.shardingsphere.proxy.backend.hbase.result.update.HBaseUpdater;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLFlushStatement;

public final class HBaseRegionReloadUpdater
implements HBaseUpdater {
    @Override
    public Collection<UpdateResult> executeUpdate(HBaseOperation operation) {
        List<String> tables = Arrays.asList(operation.getTableName().split(","));
        AtomicInteger updateCount = new AtomicInteger();
        tables.stream().filter(this::isNotNullTableName).forEach(this::checkTableExists);
        tables.stream().filter(this::isNotNullTableName).forEach(each -> {
            updateCount.getAndIncrement();
            HBaseRegionWarmUpContext.getInstance().loadRegionInfo((String)each, HBaseContext.getInstance().getConnection((String)each));
        });
        return Collections.singleton(new UpdateResult(updateCount.get(), 0L));
    }

    private void checkTableExists(String tableName) {
        ShardingSpherePreconditions.checkState((boolean)HBaseContext.getInstance().isTableExists(tableName), () -> new HBaseOperationException(String.format("Table `%s` is not exists", tableName)));
    }

    private boolean isNotNullTableName(String tableName) {
        return !"".equals(tableName) && !"null".equalsIgnoreCase(tableName);
    }

    public String getType() {
        return MySQLFlushStatement.class.getCanonicalName();
    }
}

