/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.result.update;

import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.proxy.backend.hbase.bean.HBaseOperation;
import org.apache.shardingsphere.proxy.backend.hbase.converter.operation.HBaseDeleteOperation;
import org.apache.shardingsphere.proxy.backend.hbase.executor.HBaseExecutor;
import org.apache.shardingsphere.proxy.backend.hbase.result.update.HBaseUpdater;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLDeleteStatement;

public final class HBaseDeleteUpdater
implements HBaseUpdater {
    @Override
    public Collection<UpdateResult> executeUpdate(HBaseOperation operation) {
        if (operation.getOperation() instanceof HBaseDeleteOperation) {
            int deleteAffectedSize = ((HBaseDeleteOperation)operation.getOperation()).getDeletes().size();
            HBaseExecutor.executeUpdate(operation.getTableName(), table -> table.delete(((HBaseDeleteOperation)operation.getOperation()).getDeletes()));
            return Collections.singleton(new UpdateResult(deleteAffectedSize, 0L));
        }
        HBaseExecutor.executeUpdate(operation.getTableName(), table -> table.delete((Delete)operation.getOperation()));
        return Collections.singleton(new UpdateResult(1, 0L));
    }

    public String getType() {
        return MySQLDeleteStatement.class.getCanonicalName();
    }
}

