/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.result.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dal.ShowTablesStatementContext;
import org.apache.shardingsphere.proxy.backend.hbase.bean.HBaseCluster;
import org.apache.shardingsphere.proxy.backend.hbase.context.HBaseContext;
import org.apache.shardingsphere.proxy.backend.hbase.executor.HBaseExecutor;
import org.apache.shardingsphere.proxy.backend.hbase.result.query.HBaseQueryResultSet;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dal.FromSchemaSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowTablesStatement;

public final class HBaseListResultSet
implements HBaseQueryResultSet {
    private Iterator<Map.Entry<String, String>> iterator;

    @Override
    public void init(SQLStatementContext sqlStatementContext) {
        Map<String, String> result;
        ShowTablesStatementContext context = (ShowTablesStatementContext)sqlStatementContext;
        if (context.getSqlStatement().getFromSchema().isPresent()) {
            String clusterName = ((FromSchemaSegment)context.getSqlStatement().getFromSchema().get()).getSchema().getIdentifier().getValue();
            result = this.listTablesInHBaseByFromSchema(clusterName);
        } else {
            result = this.listTablesInHBase();
        }
        this.iterator = result.entrySet().iterator();
    }

    private Map<String, String> listTablesInHBaseByFromSchema(String clusterName) {
        HTableDescriptor[] tables = HBaseExecutor.executeAdmin(HBaseContext.getInstance().getConnectionByClusterName(clusterName), Admin::listTables);
        HashMap<String, String> result = new HashMap<String, String>(tables.length);
        for (HTableDescriptor tableDescriptor : tables) {
            result.put(tableDescriptor.getNameAsString(), clusterName);
        }
        return result;
    }

    private Map<String, String> listTablesInHBase() {
        HashMap<String, String> result = new HashMap<String, String>(HBaseContext.getInstance().getTableConnectionMap().size(), 1.0f);
        for (Map.Entry<String, HBaseCluster> entry : HBaseContext.getInstance().getTableConnectionMap().entrySet()) {
            result.put(entry.getKey(), entry.getValue().getClusterName());
        }
        return result;
    }

    @Override
    public Collection<String> getColumnNames() {
        return Arrays.asList("hbase cluster name", "table name");
    }

    @Override
    public boolean next() {
        return this.iterator.hasNext();
    }

    @Override
    public Collection<Object> getRowData() {
        Map.Entry<String, String> entry = this.iterator.next();
        return Arrays.asList(entry.getValue(), entry.getKey());
    }

    public String getType() {
        return MySQLShowTablesStatement.class.getCanonicalName();
    }
}

