/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.result.query;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.proxy.backend.hbase.bean.HBaseOperation;
import org.apache.shardingsphere.proxy.backend.hbase.context.HBaseContext;
import org.apache.shardingsphere.proxy.backend.hbase.converter.HBaseOperationConverterFactory;
import org.apache.shardingsphere.proxy.backend.hbase.converter.operation.HBaseSelectOperation;
import org.apache.shardingsphere.proxy.backend.hbase.executor.HBaseExecutor;
import org.apache.shardingsphere.proxy.backend.hbase.props.HBasePropertyKey;
import org.apache.shardingsphere.proxy.backend.hbase.result.query.HBaseQueryResultSet;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.NumberLiteralLimitValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLSelectStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBaseGetResultSet
implements HBaseQueryResultSet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HBaseGetResultSet.class);
    private static final String ROW_KEY_COLUMN_NAME = "rowKey";
    private static final String CONTENT_COLUMN_NAME = "content";
    private static final String TIMESTAMP_COLUMN_NAME = "timestamp";
    private SelectStatementContext statementContext;
    private long resultNum;
    private long maxLimitResultSize;
    private Collection<String> columnNames = Collections.singleton("rowKey");
    private Result compensateResult;
    private Iterator<Result> rows;

    @Override
    public void init(SQLStatementContext sqlStatementContext) {
        this.statementContext = (SelectStatementContext)sqlStatementContext;
        this.initResultNum(sqlStatementContext);
        HBaseOperation operation = HBaseOperationConverterFactory.newInstance(sqlStatementContext).convert();
        long startMills = System.currentTimeMillis();
        if (operation.getOperation() instanceof Get) {
            this.executeGetRequest(operation);
        } else if (operation.getOperation() instanceof HBaseSelectOperation) {
            this.executeGetsRequest(operation);
        } else {
            this.executeScanRequest(operation);
        }
        this.logExecuteTime(startMills);
    }

    private void initResultNum(SQLStatementContext sqlStatementContext) {
        this.resultNum = 0L;
        this.maxLimitResultSize = (Long)HBaseContext.getInstance().getProps().getValue(HBasePropertyKey.MAX_SCAN_LIMIT_SIZE);
        Optional paginationSegment = ((MySQLSelectStatement)sqlStatementContext.getSqlStatement()).getLimit().flatMap(LimitSegment::getRowCount);
        paginationSegment.ifPresent(optional -> {
            this.maxLimitResultSize = Math.min(this.maxLimitResultSize, ((NumberLiteralLimitValueSegment)optional).getValue());
        });
    }

    private void executeGetRequest(HBaseOperation operation) {
        Result result = HBaseExecutor.executeQuery(operation.getTableName(), table -> table.get((Get)operation.getOperation()));
        Collection<Object> rows = 0 == result.rawCells().length ? Collections.emptyList() : Collections.singleton(result);
        this.rows = rows.iterator();
        this.setColumnNames(this.rows);
    }

    private void executeGetsRequest(HBaseOperation operation) {
        List<Object> results = Arrays.asList(HBaseExecutor.executeQuery(operation.getTableName(), table -> table.get(((HBaseSelectOperation)operation.getOperation()).getGets())));
        results = results.stream().filter(result -> result.rawCells().length > 0).collect(Collectors.toList());
        if (this.statementContext.getOrderByContext().isGenerated()) {
            results.sort(this::compareResult);
        }
        this.rows = results.iterator();
        this.setColumnNames(this.rows);
    }

    private int compareResult(Result result1, Result result2) {
        return Bytes.toString((byte[])result1.getRow()).compareTo(Bytes.toString((byte[])result2.getRow()));
    }

    private void executeScanRequest(HBaseOperation hbaseOperation) {
        Scan scan = (Scan)hbaseOperation.getOperation();
        scan.setLimit((int)this.maxLimitResultSize);
        ResultScanner resultScanner = HBaseExecutor.executeQuery(hbaseOperation.getTableName(), table -> table.getScanner(scan));
        this.rows = resultScanner.iterator();
        this.setColumnNames(this.rows);
    }

    private void setColumnNames(Iterator<Result> rows) {
        if (rows.hasNext()) {
            this.compensateResult = rows.next();
        }
        this.columnNames = null == this.compensateResult ? Arrays.asList(ROW_KEY_COLUMN_NAME, CONTENT_COLUMN_NAME) : this.parseResult(this.compensateResult).keySet();
    }

    private Map<String, String> parseResult(Result result) {
        TreeMap<String, String> row = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        row.put(ROW_KEY_COLUMN_NAME, Bytes.toString((byte[])result.getRow()));
        Long timestamp = null;
        for (Cell each : result.listCells()) {
            String column = new String(CellUtil.cloneQualifier((Cell)each), StandardCharsets.UTF_8);
            String value = new String(CellUtil.cloneValue((Cell)each), StandardCharsets.UTF_8);
            if (null == timestamp) {
                timestamp = each.getTimestamp();
            }
            row.put(column, value);
        }
        row.put(TIMESTAMP_COLUMN_NAME, String.valueOf(timestamp));
        return row;
    }

    private void logExecuteTime(long startMills) {
        long endMills = System.currentTimeMillis();
        String tableName = this.statementContext.getSqlStatement().getFrom() instanceof SimpleTableSegment ? ((SimpleTableSegment)this.statementContext.getSqlStatement().getFrom()).getTableName().getIdentifier().getValue() : this.statementContext.getSqlStatement().getFrom().toString();
        String whereClause = this.getWhereClause();
        if (endMills - startMills > (Long)HBaseContext.getInstance().getProps().getValue(HBasePropertyKey.EXECUTE_TIME_OUT)) {
            log.info(String.format("query hbase table: %s,  where case: %s  ,  query %dms time out", tableName, whereClause, endMills - startMills));
        } else {
            log.info(String.format("query hbase table: %s,  where case: %s  ,  execute time: %dms", tableName, whereClause, endMills - startMills));
        }
    }

    private String getWhereClause() {
        if (!this.statementContext.getSqlStatement().getWhere().isPresent()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        ExpressionSegment expressionSegment = ((WhereSegment)this.statementContext.getSqlStatement().getWhere().get()).getExpr();
        if (expressionSegment instanceof BetweenExpression) {
            result.append(((BetweenExpression)expressionSegment).getBetweenExpr());
        } else if (expressionSegment instanceof BinaryOperationExpression) {
            result.append(((BinaryOperationExpression)expressionSegment).getText());
        }
        return result.toString();
    }

    @Override
    public boolean next() {
        return this.resultNum < this.maxLimitResultSize && (this.rows.hasNext() || this.compensateResult != null);
    }

    @Override
    public Collection<Object> getRowData() {
        Map<String, String> row;
        if (null == this.compensateResult) {
            row = this.parseResult(this.rows.next());
        } else {
            row = this.parseResult(this.compensateResult);
            this.compensateResult = null;
        }
        ++this.resultNum;
        return this.columnNames.stream().map(each -> row.getOrDefault(each, "")).collect(Collectors.toList());
    }

    public String getType() {
        return MySQLSelectStatement.class.getCanonicalName();
    }

    @Override
    @Generated
    public Collection<String> getColumnNames() {
        return this.columnNames;
    }
}

