/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.result.query;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dal.ShowCreateTableStatementContext;
import org.apache.shardingsphere.proxy.backend.hbase.context.HBaseContext;
import org.apache.shardingsphere.proxy.backend.hbase.executor.HBaseExecutor;
import org.apache.shardingsphere.proxy.backend.hbase.result.query.HBaseQueryResultSet;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowCreateTableStatement;

public final class HBaseDescribeResultSet
implements HBaseQueryResultSet {
    private Iterator<HTableDescriptor> iterator;

    @Override
    public void init(SQLStatementContext sqlStatementContext) {
        ShowCreateTableStatementContext statementContext = (ShowCreateTableStatementContext)sqlStatementContext;
        String tableName = (String)statementContext.getTablesContext().getTableNames().iterator().next();
        boolean isExists = HBaseExecutor.executeAdmin(HBaseContext.getInstance().getConnection(tableName), admin -> admin.tableExists(TableName.valueOf((String)tableName)));
        Preconditions.checkArgument((boolean)isExists, (Object)String.format("Table %s is not exists", tableName));
        HTableDescriptor hTableDescriptor = HBaseExecutor.executeAdmin(HBaseContext.getInstance().getConnection(tableName), admin -> admin.getTableDescriptor(TableName.valueOf((String)tableName)));
        List<HTableDescriptor> tables = Collections.singletonList(hTableDescriptor);
        this.iterator = tables.iterator();
    }

    @Override
    public Collection<String> getColumnNames() {
        return Arrays.asList("Name", "TableAttributes", "FlushPolicyClassName", "MaxFileSize", "MemStoreFlushSize", "Priority", "RegionReplication", "RegionSplitPolicyClassName", "CustomizedValues");
    }

    @Override
    public boolean next() {
        return this.iterator.hasNext();
    }

    @Override
    public Collection<Object> getRowData() {
        HTableDescriptor descriptor = this.iterator.next();
        return Arrays.asList(descriptor.getNameAsString(), descriptor.toStringTableAttributes(), descriptor.getFlushPolicyClassName(), descriptor.getMaxFileSize(), descriptor.getMemStoreFlushSize(), descriptor.getPriority(), descriptor.getRegionReplication(), descriptor.getRegionSplitPolicyClassName(), descriptor.toStringCustomizedValues());
    }

    public String getType() {
        return MySQLShowCreateTableStatement.class.getCanonicalName();
    }
}

