/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.handler;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shardingsphere.proxy.backend.hbase.handler.HBaseErrorHintCommentQueryRowData;
import org.apache.shardingsphere.proxy.backend.hbase.result.HBaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;

public final class HBaseErrorHintCommentQueryHandler
implements HBaseBackendHandler {
    private static final Collection<String> COLUMN_NAMES = Arrays.asList("ID", "Hint", "Status");
    private final List<HBaseErrorHintCommentQueryRowData> rowDataList;
    private int currentIndex;

    public HBaseErrorHintCommentQueryHandler(String hintComment) {
        this.rowDataList = Arrays.asList(new HBaseErrorHintCommentQueryRowData(1, "HBase", true), new HBaseErrorHintCommentQueryRowData(2, StringUtils.strip((String)hintComment, (String)"* "), false));
        this.currentIndex = 0;
    }

    public ResponseHeader execute() {
        List queryHeaders = COLUMN_NAMES.stream().map(each -> new QueryHeader("", "", each, each, 1, "CHAR", 255, 0, false, false, false, false)).collect(Collectors.toList());
        return new QueryResponseHeader(queryHeaders);
    }

    public boolean next() {
        ++this.currentIndex;
        return this.currentIndex <= this.rowDataList.size();
    }

    @Override
    public Collection<Object> getRowDataObjects() {
        return this.rowDataList.get(this.currentIndex - 1).toList();
    }
}

