/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.executor;

import java.io.Closeable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class HBaseTaskExecutorManager
implements Closeable {
    private final ThreadPoolExecutor executorService;

    public HBaseTaskExecutorManager(int poolSize) {
        this.executorService = new ThreadPoolExecutor(poolSize, poolSize, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(20000), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void submit(Runnable runnable) {
        this.executorService.submit(runnable);
    }

    @Override
    public void close() {
        this.executorService.shutdown();
    }
}

