/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.executor;

import java.io.IOException;
import lombok.Generated;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Table;
import org.apache.shardingsphere.proxy.backend.hbase.context.HBaseContext;
import org.apache.shardingsphere.proxy.backend.hbase.exception.HBaseOperationException;
import org.apache.shardingsphere.proxy.backend.hbase.result.HBaseAdminCallback;
import org.apache.shardingsphere.proxy.backend.hbase.result.HBaseQueryCallback;
import org.apache.shardingsphere.proxy.backend.hbase.result.HBaseUpdateCallback;

public final class HBaseExecutor {
    public static void executeUpdate(String tableName, HBaseUpdateCallback operation) {
        try (Table table = HBaseContext.getInstance().getConnection(tableName).getTable(TableName.valueOf((String)tableName));){
            HBaseExecutor.executeUpdate(table, operation);
        }
        catch (IOException ex) {
            throw new HBaseOperationException(ex.getMessage());
        }
    }

    private static void executeUpdate(Table table, HBaseUpdateCallback operation) {
        try {
            operation.executeInHBase(table);
        }
        catch (IOException ex) {
            throw new HBaseOperationException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T executeQuery(String tableName, HBaseQueryCallback<T> operation) {
        TableName backendTableName = TableName.valueOf((String)tableName);
        try (Table table = HBaseContext.getInstance().getConnection(tableName).getTable(backendTableName);){
            T t = HBaseExecutor.executeQuery(table, operation);
            return t;
        }
        catch (IOException ex) {
            throw new HBaseOperationException(ex.getMessage());
        }
    }

    private static <T> T executeQuery(Table table, HBaseQueryCallback<T> operation) {
        try {
            return operation.executeInHBase(table);
        }
        catch (IOException ex) {
            throw new HBaseOperationException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T executeAdmin(Connection connection, HBaseAdminCallback<T> operation) {
        try (Admin admin = connection.getAdmin();){
            T t = HBaseExecutor.executeAdmin(admin, operation);
            return t;
        }
        catch (IOException ex) {
            throw new HBaseOperationException(ex.getMessage());
        }
    }

    private static <T> T executeAdmin(Admin admin, HBaseAdminCallback<T> operation) {
        try {
            return operation.executeInHBase(admin);
        }
        catch (IOException ex) {
            throw new HBaseOperationException(ex.getMessage());
        }
    }

    @Generated
    private HBaseExecutor() {
    }
}

