/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.executor;

import java.io.Closeable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.shardingsphere.infra.executor.kernel.thread.ExecutorThreadFactoryBuilder;

public final class HBaseBackgroundExecutorManager
implements Closeable {
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, ExecutorThreadFactoryBuilder.build((String)"background"));

    public void submit(Runnable runnable, int interval) {
        this.executorService.scheduleWithFixedDelay(runnable, interval, interval, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        this.executorService.shutdown();
    }
}

