/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.converter.type;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.hadoop.hbase.client.Operation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.UpdateStatementContext;
import org.apache.shardingsphere.proxy.backend.hbase.bean.HBaseOperation;
import org.apache.shardingsphere.proxy.backend.hbase.converter.HBaseOperationConverter;
import org.apache.shardingsphere.proxy.backend.hbase.converter.HBaseRowKeyExtractor;
import org.apache.shardingsphere.proxy.backend.hbase.converter.operation.HBaseUpdateOperation;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;

public final class HBaseUpdateOperationConverter
implements HBaseOperationConverter {
    private final SQLStatementContext sqlStatementContext;

    @Override
    public HBaseOperation convert() {
        UpdateStatementContext updateStatementContext = (UpdateStatementContext)this.sqlStatementContext;
        Optional whereSegment = updateStatementContext.getWhereSegments().stream().findFirst();
        Preconditions.checkArgument((boolean)whereSegment.isPresent(), (Object)"Where segment is absent.");
        return ((WhereSegment)whereSegment.get()).getExpr() instanceof InExpression ? this.createUpdateMultipleRowKeysOperation(updateStatementContext, (WhereSegment)whereSegment.get()) : this.createUpdateSingleRowKeyOperation(updateStatementContext, (WhereSegment)whereSegment.get());
    }

    private HBaseOperation createUpdateMultipleRowKeysOperation(UpdateStatementContext updateStatementContext, WhereSegment whereSegment) {
        String tableName = (String)updateStatementContext.getTablesContext().getTableNames().iterator().next();
        List<Put> puts = HBaseRowKeyExtractor.getRowKeys((InExpression)whereSegment.getExpr()).stream().map(each -> new Put(Bytes.toBytes((String)each))).collect(Collectors.toList());
        for (Put each2 : puts) {
            this.addPutColumn(updateStatementContext, each2);
        }
        return new HBaseOperation(tableName, new HBaseUpdateOperation(puts));
    }

    private HBaseOperation createUpdateSingleRowKeyOperation(UpdateStatementContext updateStatementContext, WhereSegment whereSegment) {
        String tableName = (String)updateStatementContext.getTablesContext().getTableNames().iterator().next();
        return new HBaseOperation(tableName, (Operation)this.createOperationRequest(updateStatementContext, whereSegment));
    }

    private Put createOperationRequest(UpdateStatementContext updateStatementContext, WhereSegment whereSegment) {
        Put result = new Put(Bytes.toBytes((String)HBaseRowKeyExtractor.getRowKey((BinaryOperationExpression)whereSegment.getExpr())));
        this.addPutColumn(updateStatementContext, result);
        return result;
    }

    private void addPutColumn(UpdateStatementContext updateStatementContext, Put put) {
        for (AssignmentSegment each : updateStatementContext.getSqlStatement().getSetAssignment().getAssignments()) {
            String columnName = ((ColumnSegment)each.getColumns().iterator().next()).getIdentifier().getValue();
            String value = String.valueOf(((LiteralExpressionSegment)each.getValue()).getLiterals());
            put.addColumn(Bytes.toBytes((String)"i"), Bytes.toBytes((String)columnName), Bytes.toBytes((String)value));
        }
    }

    @Generated
    public HBaseUpdateOperationConverter(SQLStatementContext sqlStatementContext) {
        this.sqlStatementContext = sqlStatementContext;
    }
}

