/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.converter.type;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Operation;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.proxy.backend.hbase.bean.HBaseOperation;
import org.apache.shardingsphere.proxy.backend.hbase.converter.HBaseOperationConverter;
import org.apache.shardingsphere.proxy.backend.hbase.converter.HBaseRowKeyExtractor;
import org.apache.shardingsphere.proxy.backend.hbase.converter.operation.HBaseSelectOperation;
import org.apache.shardingsphere.proxy.backend.hbase.util.HBaseHeterogeneousUtils;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.NumberLiteralLimitValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLSelectStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBaseSelectOperationConverter
implements HBaseOperationConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HBaseSelectOperationConverter.class);
    private final SQLStatementContext sqlStatementContext;

    @Override
    public HBaseOperation convert() {
        SelectStatementContext selectStatementContext = (SelectStatementContext)this.sqlStatementContext;
        Optional whereSegment = selectStatementContext.getWhereSegments().stream().findFirst();
        Preconditions.checkArgument((boolean)whereSegment.isPresent(), (Object)"Where segment is absent.");
        return ((WhereSegment)whereSegment.get()).getExpr() instanceof BinaryOperationExpression || ((WhereSegment)whereSegment.get()).getExpr() instanceof InExpression ? this.createGetOperation(selectStatementContext, (WhereSegment)whereSegment.get()) : this.createScanOperation(selectStatementContext, (WhereSegment)whereSegment.get());
    }

    private HBaseOperation createGetOperation(SelectStatementContext selectStatementContext, WhereSegment whereSegment) {
        ExpressionSegment expr = whereSegment.getExpr();
        List<Get> gets = this.getRowKeys(expr).stream().map(each -> new Get(Bytes.toBytes((String)each))).collect(Collectors.toList());
        if (!HBaseHeterogeneousUtils.isUseShorthandProjection(selectStatementContext)) {
            for (Get each2 : gets) {
                this.appendColumns((Query)each2, selectStatementContext);
            }
        }
        String tableName = (String)selectStatementContext.getTablesContext().getTableNames().iterator().next();
        return expr instanceof InExpression ? new HBaseOperation(tableName, new HBaseSelectOperation(gets)) : new HBaseOperation(tableName, (Operation)gets.get(0));
    }

    private List<String> getRowKeys(ExpressionSegment expr) {
        return expr instanceof InExpression ? HBaseRowKeyExtractor.getRowKeys((InExpression)expr) : Collections.singletonList(HBaseRowKeyExtractor.getRowKey((BinaryOperationExpression)expr));
    }

    private HBaseOperation createScanOperation(SelectStatementContext selectStatementContext, WhereSegment whereSegment) {
        Scan scan = new Scan();
        if (whereSegment.getExpr() instanceof BetweenExpression) {
            this.appendBetween(scan, whereSegment.getExpr(), false);
        }
        if (!HBaseHeterogeneousUtils.isUseShorthandProjection(selectStatementContext)) {
            this.appendColumns((Query)scan, selectStatementContext);
        }
        this.appendLimit(scan, selectStatementContext);
        return new HBaseOperation((String)selectStatementContext.getTablesContext().getTableNames().iterator().next(), (Operation)scan);
    }

    private void appendColumns(Query query, SelectStatementContext selectStatementContext) {
        if (query instanceof Get) {
            selectStatementContext.getColumnSegments().forEach(each -> ((Get)query).addColumn(Bytes.toBytes((String)"i"), Bytes.toBytes((String)String.valueOf(each))));
        } else {
            selectStatementContext.getColumnSegments().forEach(each -> ((Scan)query).addColumn(Bytes.toBytes((String)"i"), Bytes.toBytes((String)String.valueOf(each))));
        }
    }

    private void appendBetween(Scan scan, ExpressionSegment expressionSegment, boolean reversed) {
        BetweenExpression betweenExpr = (BetweenExpression)expressionSegment;
        String startRowKey = ((LiteralExpressionSegment)betweenExpr.getBetweenExpr()).getLiterals().toString();
        String stopRowKey = ((LiteralExpressionSegment)betweenExpr.getAndExpr()).getLiterals().toString();
        if (null != startRowKey && null != stopRowKey) {
            if (reversed) {
                scan.withStopRow(this.calBytes(startRowKey, 0), true);
                scan.withStartRow(this.calBytes(stopRowKey + "~", 0), true);
            } else {
                scan.withStartRow(this.calBytes(startRowKey, 0), true);
                scan.withStopRow(this.calBytes(stopRowKey + "~", 0), true);
            }
        }
    }

    private byte[] calBytes(String row, int step) {
        byte[] rowByte = Bytes.toBytes((String)row);
        byte[] result = Arrays.copyOf(rowByte, rowByte.length);
        result[result.length - 1] = (byte)(result[result.length - 1] + step);
        return result;
    }

    private void appendLimit(Scan scan, SelectStatementContext selectStatementContext) {
        MySQLSelectStatement selectStatement = (MySQLSelectStatement)selectStatementContext.getSqlStatement();
        if (selectStatement.getLimit().isPresent()) {
            ((LimitSegment)selectStatement.getLimit().get()).getRowCount().ifPresent(optional -> scan.setLimit((int)((NumberLiteralLimitValueSegment)optional).getValue()));
        }
    }

    @Generated
    public HBaseSelectOperationConverter(SQLStatementContext sqlStatementContext) {
        this.sqlStatementContext = sqlStatementContext;
    }
}

