/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.converter.type;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.shardingsphere.infra.binder.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.proxy.backend.hbase.bean.HBaseOperation;
import org.apache.shardingsphere.proxy.backend.hbase.context.HBaseContext;
import org.apache.shardingsphere.proxy.backend.hbase.converter.HBaseOperationConverter;
import org.apache.shardingsphere.proxy.backend.hbase.converter.operation.HBaseInsertOperation;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;

public final class HBaseInsertOperationConverter
implements HBaseOperationConverter {
    private final SQLStatementContext sqlStatementContext;

    @Override
    public HBaseOperation convert() {
        InsertStatementContext insertStatementContext = (InsertStatementContext)this.sqlStatementContext;
        String tableName = (String)insertStatementContext.getTablesContext().getTableNames().iterator().next();
        return new HBaseOperation(tableName, new HBaseInsertOperation(this.createHBaseRequest(insertStatementContext)));
    }

    private List<Put> createHBaseRequest(InsertStatementContext insertStatementContext) {
        return insertStatementContext.getInsertValueContexts().stream().map(each -> this.generateHBaseRequest(insertStatementContext, (InsertValueContext)each)).collect(Collectors.toList());
    }

    private Put generateHBaseRequest(InsertStatementContext insertStatementContext, InsertValueContext insertValueContext) {
        List columns = insertStatementContext.getInsertColumnNames();
        List values = insertValueContext.getValueExpressions().stream().map(each -> ((LiteralExpressionSegment)each).getLiterals()).collect(Collectors.toList());
        Put result = new Put(Bytes.toBytes((String)String.valueOf(values.get(0))));
        for (int i = 1; i < columns.size(); ++i) {
            result.addColumn(Bytes.toBytes((String)HBaseContext.getInstance().getColumnFamily()), Bytes.toBytes((String)String.valueOf(columns.get(i))), Bytes.toBytes((String)String.valueOf(values.get(i))));
        }
        return result;
    }

    @Generated
    public HBaseInsertOperationConverter(SQLStatementContext sqlStatementContext) {
        this.sqlStatementContext = sqlStatementContext;
    }
}

