/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.converter.type;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Operation;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.DeleteStatementContext;
import org.apache.shardingsphere.proxy.backend.hbase.bean.HBaseOperation;
import org.apache.shardingsphere.proxy.backend.hbase.converter.HBaseOperationConverter;
import org.apache.shardingsphere.proxy.backend.hbase.converter.HBaseRowKeyExtractor;
import org.apache.shardingsphere.proxy.backend.hbase.converter.operation.HBaseDeleteOperation;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;

public final class HBaseDeleteOperationConverter
implements HBaseOperationConverter {
    private final SQLStatementContext sqlStatementContext;

    @Override
    public HBaseOperation convert() {
        DeleteStatementContext deleteStatementContext = (DeleteStatementContext)this.sqlStatementContext;
        Optional whereSegment = deleteStatementContext.getWhereSegments().stream().findFirst();
        Preconditions.checkArgument((boolean)whereSegment.isPresent(), (Object)"Where segment is absent.");
        return ((WhereSegment)whereSegment.get()).getExpr() instanceof InExpression ? this.createDeleteMultipleRowKeysOperation(deleteStatementContext, (WhereSegment)whereSegment.get()) : this.createDeleteSingleRowKeyOperation(deleteStatementContext, (WhereSegment)whereSegment.get());
    }

    private HBaseOperation createDeleteMultipleRowKeysOperation(DeleteStatementContext deleteStatementContext, WhereSegment whereSegment) {
        String tableName = (String)deleteStatementContext.getTablesContext().getTableNames().iterator().next();
        List<String> rowKeys = HBaseRowKeyExtractor.getRowKeys((InExpression)whereSegment.getExpr());
        List<Delete> deletes = rowKeys.stream().map(each -> new Delete(Bytes.toBytes((String)each))).collect(Collectors.toList());
        return new HBaseOperation(tableName, new HBaseDeleteOperation(deletes));
    }

    private HBaseOperation createDeleteSingleRowKeyOperation(DeleteStatementContext deleteStatementContext, WhereSegment whereSegment) {
        String tableName = (String)deleteStatementContext.getTablesContext().getTableNames().iterator().next();
        String rowKey = HBaseRowKeyExtractor.getRowKey((BinaryOperationExpression)whereSegment.getExpr());
        Delete delete = new Delete(Bytes.toBytes((String)rowKey));
        return new HBaseOperation(tableName, (Operation)delete);
    }

    @Generated
    public HBaseDeleteOperationConverter(SQLStatementContext sqlStatementContext) {
        this.sqlStatementContext = sqlStatementContext;
    }
}

