/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.converter;

import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dal.FlushStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.DeleteStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.UpdateStatementContext;
import org.apache.shardingsphere.proxy.backend.hbase.converter.HBaseOperationConverter;
import org.apache.shardingsphere.proxy.backend.hbase.converter.type.HBaseDeleteOperationConverter;
import org.apache.shardingsphere.proxy.backend.hbase.converter.type.HBaseInsertOperationConverter;
import org.apache.shardingsphere.proxy.backend.hbase.converter.type.HBaseRegionReloadOperationConverter;
import org.apache.shardingsphere.proxy.backend.hbase.converter.type.HBaseSelectOperationConverter;
import org.apache.shardingsphere.proxy.backend.hbase.converter.type.HBaseUpdateOperationConverter;
import org.apache.shardingsphere.proxy.backend.hbase.exception.HBaseOperationException;

public final class HBaseOperationConverterFactory {
    public static HBaseOperationConverter newInstance(SQLStatementContext sqlStatementContext) {
        if (sqlStatementContext instanceof SelectStatementContext) {
            return new HBaseSelectOperationConverter(sqlStatementContext);
        }
        if (sqlStatementContext instanceof InsertStatementContext) {
            return new HBaseInsertOperationConverter(sqlStatementContext);
        }
        if (sqlStatementContext instanceof DeleteStatementContext) {
            return new HBaseDeleteOperationConverter(sqlStatementContext);
        }
        if (sqlStatementContext instanceof UpdateStatementContext) {
            return new HBaseUpdateOperationConverter(sqlStatementContext);
        }
        if (sqlStatementContext instanceof FlushStatementContext) {
            return new HBaseRegionReloadOperationConverter(sqlStatementContext);
        }
        throw new HBaseOperationException("Can not find HBase converter.");
    }

    @Generated
    private HBaseOperationConverterFactory() {
    }
}

