/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.context;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.shardingsphere.proxy.backend.hbase.bean.HBaseCluster;
import org.apache.shardingsphere.proxy.backend.hbase.exception.HBaseOperationException;
import org.apache.shardingsphere.proxy.backend.hbase.executor.HBaseTaskExecutorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBaseRegionWarmUpContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HBaseRegionWarmUpContext.class);
    private static final HBaseRegionWarmUpContext INSTANCE = new HBaseRegionWarmUpContext();
    private final AtomicInteger executeCount = new AtomicInteger(0);
    private final AtomicInteger tableCount = new AtomicInteger(0);
    private HBaseTaskExecutorManager executorManager;
    private long startWarmUpTime;

    public static HBaseRegionWarmUpContext getInstance() {
        return INSTANCE;
    }

    public void init(int poolSize) {
        this.executorManager = new HBaseTaskExecutorManager(poolSize);
    }

    public void submitWarmUpTask(String tableName, HBaseCluster hbaseCluster) {
        this.executorManager.submit(() -> this.loadRegionInfo(tableName, hbaseCluster));
    }

    public void loadRegionInfo(String tableName, Connection connection) {
        HBaseRegionWarmUpContext.getInstance().addExecuteCount();
        try {
            if (connection == null) {
                return;
            }
            RegionLocator regionLocator = connection.getRegionLocator(TableName.valueOf((String)tableName));
            regionLocator.getAllRegionLocations();
        }
        catch (IOException e) {
            throw new HBaseOperationException(String.format("table: %s warm up error, getRegionLocator execute error reason is  %s", tableName, e));
        }
    }

    private void loadRegionInfo(String tableName, HBaseCluster hbaseCluster) {
        try {
            RegionLocator regionLocator = hbaseCluster.getConnection().getRegionLocator(TableName.valueOf((String)tableName));
            this.warmUpRegion(regionLocator);
            HBaseRegionWarmUpContext.getInstance().addExecuteCount();
        }
        catch (IOException ex) {
            log.error(String.format("Table: `%s` load region info error, reason is  %s", tableName, ex));
        }
    }

    private void warmUpRegion(RegionLocator regionLocator) throws IOException {
        regionLocator.getAllRegionLocations();
    }

    public void initStatisticsInfo(long startWarmUpTime) {
        this.startWarmUpTime = startWarmUpTime;
    }

    public void addExecuteCount() {
        this.executeCount.incrementAndGet();
    }

    public void addNeedWarmCount() {
        this.tableCount.incrementAndGet();
    }

    public void syncExecuteWarmUp(String clusterName) {
        while (this.executeCount.get() < this.tableCount.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
        log.info(String.format("%s cluster end warm up, execute time: %dms, warm table: %d", clusterName, System.currentTimeMillis() - this.startWarmUpTime, this.executeCount.get()));
    }

    public void clear() {
        this.tableCount.set(0);
        this.executeCount.set(0);
    }

    @Generated
    public AtomicInteger getExecuteCount() {
        return this.executeCount;
    }

    @Generated
    public AtomicInteger getTableCount() {
        return this.tableCount;
    }

    @Generated
    public HBaseTaskExecutorManager getExecutorManager() {
        return this.executorManager;
    }

    @Generated
    public long getStartWarmUpTime() {
        return this.startWarmUpTime;
    }
}

