/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.proxy.backend.hbase.bean.HBaseCluster;
import org.apache.shardingsphere.proxy.backend.hbase.context.HBaseRegionWarmUpContext;
import org.apache.shardingsphere.proxy.backend.hbase.exception.HBaseOperationException;
import org.apache.shardingsphere.proxy.backend.hbase.executor.HBaseBackgroundExecutorManager;
import org.apache.shardingsphere.proxy.backend.hbase.executor.HBaseExecutor;
import org.apache.shardingsphere.proxy.backend.hbase.props.HBaseProperties;
import org.apache.shardingsphere.proxy.backend.hbase.props.HBasePropertyKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBaseContext
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HBaseContext.class);
    private static final HBaseContext INSTANCE = new HBaseContext();
    private final HBaseBackgroundExecutorManager executorManager = new HBaseBackgroundExecutorManager();
    private HBaseRegionWarmUpContext warmUpContext;
    private HBaseProperties props;
    private final String columnFamily = "i";
    private Collection<HBaseCluster> connections;
    private boolean isSyncWarmUp;
    private final Map<String, HBaseCluster> tableConnectionMap = new ConcurrentHashMap<String, HBaseCluster>();

    public static HBaseContext getInstance() {
        return INSTANCE;
    }

    public void init(Map<String, Connection> connections) {
        this.connections = new ArrayList<HBaseCluster>(connections.size());
        this.warmUpContext = HBaseRegionWarmUpContext.getInstance();
        this.warmUpContext.init(this.getWarmUpThreadSize());
        this.isSyncWarmUp = (Boolean)HBaseContext.getInstance().getProps().getValue(HBasePropertyKey.IS_SYNC_WARM_UP);
        for (Map.Entry<String, Connection> entry : connections.entrySet()) {
            HBaseCluster cluster = new HBaseCluster(entry.getKey(), entry.getValue());
            this.loadTables(cluster);
            this.connections.add(cluster);
        }
        log.info("{} tables loaded from {} clusters.", (Object)this.tableConnectionMap.size(), (Object)connections.size());
    }

    private int getWarmUpThreadSize() {
        int warmUpThreadSize = (Integer)HBaseContext.getInstance().getProps().getValue(HBasePropertyKey.WARM_UP_THREAD_NUM);
        return warmUpThreadSize < 0 ? 1 : Math.min(warmUpThreadSize, 30);
    }

    public synchronized void loadTables(HBaseCluster hbaseCluster) {
        this.warmUpContext.initStatisticsInfo(System.currentTimeMillis());
        HTableDescriptor[] hTableDescriptor = HBaseExecutor.executeAdmin(hbaseCluster.getConnection(), Admin::listTables);
        for (String each : Arrays.stream(hTableDescriptor).map(HTableDescriptor::getNameAsString).collect(Collectors.toList())) {
            if (this.tableConnectionMap.containsKey(each)) continue;
            this.warmUpContext.addNeedWarmCount();
            log.info("Load table `{}` from cluster `{}`.", (Object)each, (Object)hbaseCluster.getClusterName());
            this.tableConnectionMap.put(each, hbaseCluster);
            this.warmUpContext.submitWarmUpTask(each, hbaseCluster);
        }
        if (this.isSyncWarmUp) {
            this.warmUpContext.syncExecuteWarmUp(hbaseCluster.getClusterName());
            this.warmUpContext.clear();
        }
    }

    public Connection getConnection(String tableName) {
        ShardingSpherePreconditions.checkState((boolean)this.tableConnectionMap.containsKey(tableName), () -> new HBaseOperationException(String.format("Table `%s` is not exists", tableName)));
        return this.tableConnectionMap.get(tableName).getConnection();
    }

    public boolean isTableExists(String tableName) {
        return this.tableConnectionMap.containsKey(tableName);
    }

    public Connection getConnectionByClusterName(String clusterName) {
        Optional<HBaseCluster> cluster = this.connections.stream().filter(each -> each.getClusterName().equalsIgnoreCase(clusterName)).findFirst();
        ShardingSpherePreconditions.checkState((boolean)cluster.isPresent(), () -> new HBaseOperationException(String.format("Cluster `%s` is not exists", clusterName)));
        return cluster.get().getConnection();
    }

    @Override
    public void close() {
        this.connections.clear();
        this.tableConnectionMap.clear();
        this.executorManager.close();
        for (Connection connection : this.connections.stream().map(HBaseCluster::getConnection).collect(Collectors.toList())) {
            try {
                connection.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Generated
    private HBaseContext() {
    }

    @Generated
    public HBaseBackgroundExecutorManager getExecutorManager() {
        return this.executorManager;
    }

    @Generated
    public HBaseRegionWarmUpContext getWarmUpContext() {
        return this.warmUpContext;
    }

    @Generated
    public HBaseProperties getProps() {
        return this.props;
    }

    @Generated
    public String getColumnFamily() {
        return this.columnFamily;
    }

    @Generated
    public Collection<HBaseCluster> getConnections() {
        return this.connections;
    }

    @Generated
    public boolean isSyncWarmUp() {
        return this.isSyncWarmUp;
    }

    @Generated
    public Map<String, HBaseCluster> getTableConnectionMap() {
        return this.tableConnectionMap;
    }

    @Generated
    public void setProps(HBaseProperties props) {
        this.props = props;
    }
}

