/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.connector;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.shardingsphere.proxy.backend.hbase.config.YamlHBaseConfiguration;
import org.apache.shardingsphere.proxy.backend.hbase.config.YamlHBaseParameter;
import org.apache.shardingsphere.proxy.backend.hbase.exception.HBaseOperationException;

public final class HBaseConnectionFactory {
    public static Map<String, Connection> createHBaseConnections(YamlHBaseConfiguration yamlProxyHBaseConfiguration) {
        LinkedHashMap<String, Connection> result = new LinkedHashMap<String, Connection>(yamlProxyHBaseConfiguration.getDataSources().size(), 1.0f);
        for (Map.Entry<String, YamlHBaseParameter> entry : yamlProxyHBaseConfiguration.getDataSources().entrySet()) {
            result.put(entry.getKey(), HBaseConnectionFactory.createConnection(entry.getValue()));
        }
        return result;
    }

    private static Connection createConnection(YamlHBaseParameter parameter) {
        Configuration config = HBaseConnectionFactory.createConfiguration(parameter);
        try {
            return Strings.isNullOrEmpty((String)parameter.getAccessUser()) ? ConnectionFactory.createConnection((Configuration)config) : ConnectionFactory.createConnection((Configuration)config, (User)User.create((UserGroupInformation)UserGroupInformation.createRemoteUser((String)parameter.getAccessUser())));
        }
        catch (IOException ex) {
            throw new HBaseOperationException(ex.getMessage());
        }
    }

    private static Configuration createConfiguration(YamlHBaseParameter parameter) {
        Configuration result = HBaseConfiguration.create();
        result.set("fs.defaultFS", parameter.getFsDefaultFs());
        result.set("hbase.rootdir", parameter.getHbaseRootDir());
        result.setLong("hbase.rpc.timeout", parameter.getHbaseRpcTimeout());
        result.setLong("hbase.client.operation.timeout", parameter.getHbaseClientOperationTimeout());
        result.setLong("hbase.client.scanner.timeout.period", parameter.getHbaseClientScannerTimeoutPeriod());
        result.set("hbase.zookeeper.property.dataDir", parameter.getHbaseZookeeperPropertyDataDir());
        result.set("hbase.zookeeper.quorum", parameter.getHbaseZookeeperQuorum());
        result.set("zookeeper.znode.parent", parameter.getZookeeperZNodeParent());
        result.setInt("hbase.client.ipc.pool.size", parameter.getIpcPoolSize());
        return result;
    }

    @Generated
    private HBaseConnectionFactory() {
    }
}

