/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.checker;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.proxy.backend.hbase.checker.CommonHeterogeneousSQLStatementChecker;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;

public final class HeterogeneousUpdateStatementChecker
extends CommonHeterogeneousSQLStatementChecker {
    private final UpdateStatement sqlStatement;

    public HeterogeneousUpdateStatementChecker(UpdateStatement sqlStatement) {
        super((SQLStatement)sqlStatement);
        this.sqlStatement = sqlStatement;
    }

    @Override
    public void execute() {
        Optional whereSegment = this.sqlStatement.getWhere();
        Preconditions.checkArgument((boolean)whereSegment.isPresent(), (Object)"Must contain where segment.");
        if (((WhereSegment)whereSegment.get()).getExpr() instanceof InExpression) {
            this.checkInExpressionIsExpected(((WhereSegment)whereSegment.get()).getExpr());
        } else {
            this.checkIsSinglePointQuery((WhereSegment)whereSegment.get());
        }
        this.checkAssignmentIsOk();
    }

    private void checkAssignmentIsOk() {
        Collection assignmentSegments = this.sqlStatement.getSetAssignment().getAssignments();
        for (AssignmentSegment assignmentSegment : assignmentSegments) {
            Preconditions.checkArgument((boolean)this.isAllowExpressionSegment(assignmentSegment.getValue()), (Object)"Assignment must is literal or parameter marker.");
            boolean isRowKey = ALLOW_KEYS.stream().anyMatch(each -> each.equalsIgnoreCase(((ColumnSegment)assignmentSegment.getColumns().iterator().next()).getIdentifier().getValue()));
            Preconditions.checkArgument((!isRowKey ? 1 : 0) != 0, (Object)"Do not allow update rowKey");
        }
    }
}

