/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.checker;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.shardingsphere.proxy.backend.hbase.checker.CommonHeterogeneousSQLStatementChecker;
import org.apache.shardingsphere.proxy.backend.hbase.context.HBaseContext;
import org.apache.shardingsphere.proxy.backend.hbase.props.HBasePropertyKey;
import org.apache.shardingsphere.proxy.backend.hbase.util.HBaseHeterogeneousUtils;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.NumberLiteralLimitValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLSelectStatement;

public final class HeterogeneousSelectStatementChecker
extends CommonHeterogeneousSQLStatementChecker {
    private final SelectStatement sqlStatement;

    public HeterogeneousSelectStatementChecker(SelectStatement sqlStatement) {
        super((SQLStatement)sqlStatement);
        this.sqlStatement = sqlStatement;
    }

    @Override
    public void execute() {
        this.checkProjectionsIsExpected();
        this.checkDoNotSupportedSegment();
        this.checkSupportedWhereSegment();
        this.checkSupportedOrderBySegment();
    }

    private void checkDoNotSupportedSegment() {
        Preconditions.checkArgument((boolean)(this.sqlStatement.getFrom() instanceof SimpleTableSegment), (Object)"Only supported simple table segment.");
        Preconditions.checkArgument((!this.sqlStatement.getHaving().isPresent() ? 1 : 0) != 0, (Object)"Do not supported having segment.");
        Preconditions.checkArgument((!this.sqlStatement.getGroupBy().isPresent() ? 1 : 0) != 0, (Object)"Do not supported group by segment.");
        MySQLSelectStatement selectStatement = (MySQLSelectStatement)this.sqlStatement;
        Preconditions.checkArgument((!selectStatement.getWindow().isPresent() ? 1 : 0) != 0, (Object)"Do not supported window segment.");
        Preconditions.checkArgument((!selectStatement.getLock().isPresent() ? 1 : 0) != 0, (Object)"Do not supported lock segment.");
        Optional limitSegment = selectStatement.getLimit();
        if (limitSegment.isPresent()) {
            Preconditions.checkArgument((!((LimitSegment)limitSegment.get()).getOffset().isPresent() ? 1 : 0) != 0, (Object)"Do not supported offset segment.");
            Optional paginationSegment = selectStatement.getLimit().flatMap(LimitSegment::getRowCount);
            Long maxScanLimitSize = (Long)HBaseContext.getInstance().getProps().getValue(HBasePropertyKey.MAX_SCAN_LIMIT_SIZE);
            paginationSegment.ifPresent(optional -> Preconditions.checkArgument((((NumberLiteralLimitValueSegment)optional).getValue() <= maxScanLimitSize ? 1 : 0) != 0, (Object)"Row count must less than 5000."));
        }
    }

    private void checkProjectionsIsExpected() {
        for (ProjectionSegment projectionSegment : this.sqlStatement.getProjections().getProjections()) {
            if (projectionSegment instanceof ShorthandProjectionSegment || projectionSegment instanceof ColumnProjectionSegment || HBaseHeterogeneousUtils.isCrcProjectionSegment(projectionSegment)) continue;
            throw new IllegalArgumentException("Only supported shorthand, column and crc32 expression projections.");
        }
    }

    private void checkSupportedWhereSegment() {
        Optional whereSegment = this.sqlStatement.getWhere();
        if (!whereSegment.isPresent()) {
            return;
        }
        ExpressionSegment whereExpr = ((WhereSegment)whereSegment.get()).getExpr();
        if (whereExpr instanceof BinaryOperationExpression) {
            this.checkIsSinglePointQuery((WhereSegment)whereSegment.get());
        } else if (whereExpr instanceof InExpression) {
            this.checkInExpressionIsExpected(whereExpr);
        } else if (whereExpr instanceof BetweenExpression) {
            this.checkBetweenExpressionIsExpected(whereExpr);
        } else {
            throw new IllegalArgumentException("Only supported =\u3001in\u3001between...and...");
        }
    }

    private void checkBetweenExpressionIsExpected(ExpressionSegment whereExpr) {
        BetweenExpression expression = (BetweenExpression)whereExpr;
        Preconditions.checkArgument((boolean)(expression.getLeft() instanceof ColumnSegment), (Object)"Left segment must column segment.");
        String rowKey = ((ColumnSegment)expression.getLeft()).getIdentifier().getValue();
        boolean isAllowKey = ALLOW_KEYS.stream().anyMatch(each -> each.equalsIgnoreCase(rowKey));
        Preconditions.checkArgument((boolean)isAllowKey, (Object)String.format("%s is not a allowed key.", rowKey));
        Preconditions.checkArgument((!expression.isNot() ? 1 : 0) != 0, (Object)"Do not supported `not between...and...`");
        Preconditions.checkArgument((boolean)this.isAllowExpressionSegment(expression.getBetweenExpr()), (Object)"Between expr must literal or parameter marker.");
        Preconditions.checkArgument((boolean)this.isAllowExpressionSegment(expression.getAndExpr()), (Object)"Between expr must literal or parameter marker.");
    }

    private void checkSupportedOrderBySegment() {
        if (!this.sqlStatement.getOrderBy().isPresent()) {
            return;
        }
        for (OrderByItemSegment orderByItemSegment : ((OrderBySegment)this.sqlStatement.getOrderBy().get()).getOrderByItems()) {
            if (!(orderByItemSegment instanceof ColumnOrderByItemSegment)) {
                throw new IllegalArgumentException("Only simple row key order by.");
            }
            if ("rowKey".equalsIgnoreCase(((ColumnOrderByItemSegment)orderByItemSegment).getColumn().getIdentifier().getValue())) continue;
            throw new IllegalArgumentException("Only simple row key order by.");
        }
    }
}

