/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.checker;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shardingsphere.proxy.backend.hbase.checker.CommonHeterogeneousSQLStatementChecker;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLInsertStatement;

public final class HeterogeneousInsertStatementChecker
extends CommonHeterogeneousSQLStatementChecker {
    private final InsertStatement sqlStatement;

    public HeterogeneousInsertStatementChecker(InsertStatement sqlStatement) {
        super((SQLStatement)sqlStatement);
        this.sqlStatement = sqlStatement;
    }

    @Override
    public void execute() {
        this.checkIsExistsRowKeyInInsertColumns();
        this.checkIsExistsSubQuery();
        this.checkValueIsExpected();
        this.checkOnDuplicateKey();
    }

    private void checkIsExistsRowKeyInInsertColumns() {
        List columns = this.sqlStatement.getColumns().stream().map(each -> each.getIdentifier().getValue()).collect(Collectors.toList());
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (Object)"The inserted column must be explicitly specified.");
        Preconditions.checkArgument((boolean)ALLOW_KEYS.stream().anyMatch(each -> each.equalsIgnoreCase((String)columns.get(0))), (Object)"First column must be rowKey.");
        boolean isExists = columns.subList(1, columns.size()).stream().anyMatch(ALLOW_KEYS::contains);
        Preconditions.checkArgument((!isExists ? 1 : 0) != 0, (Object)"Cannot contain multiple rowKeys.");
    }

    private void checkIsExistsSubQuery() {
        Preconditions.checkArgument((!this.sqlStatement.getInsertSelect().isPresent() ? 1 : 0) != 0, (Object)"Do not supported `insert into...select...`");
    }

    private void checkValueIsExpected() {
        Collection values = this.sqlStatement.getValues();
        for (InsertValuesSegment insertValuesSegment : values) {
            boolean isAllMatch = insertValuesSegment.getValues().stream().allMatch(this::isAllowExpressionSegment);
            Preconditions.checkArgument((boolean)isAllMatch, (Object)"Value must is literal or parameter marker.");
        }
    }

    private void checkOnDuplicateKey() {
        Preconditions.checkArgument((!((MySQLInsertStatement)this.sqlStatement).getOnDuplicateKeyColumns().isPresent() ? 1 : 0) != 0, (Object)"Do not supported ON DUPLICATE KEY UPDATE");
    }
}

