/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.checker;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.shardingsphere.proxy.backend.hbase.checker.CommonHeterogeneousSQLStatementChecker;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DeleteStatement;

public final class HeterogeneousDeleteStatementChecker
extends CommonHeterogeneousSQLStatementChecker {
    private final DeleteStatement sqlStatement;

    public HeterogeneousDeleteStatementChecker(DeleteStatement sqlStatement) {
        super((SQLStatement)sqlStatement);
        this.sqlStatement = sqlStatement;
    }

    @Override
    public void execute() {
        Optional whereSegment = this.sqlStatement.getWhere();
        Preconditions.checkArgument((boolean)whereSegment.isPresent(), (Object)"Must contain where segment.");
        if (((WhereSegment)whereSegment.get()).getExpr() instanceof InExpression) {
            this.checkInExpressionIsExpected(((WhereSegment)whereSegment.get()).getExpr());
        } else {
            this.checkIsSinglePointQuery((WhereSegment)whereSegment.get());
        }
    }
}

