/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.checker;

import lombok.Generated;
import org.apache.shardingsphere.proxy.backend.hbase.checker.CommonHeterogeneousSQLStatementChecker;
import org.apache.shardingsphere.proxy.backend.hbase.checker.HeterogeneousDeleteStatementChecker;
import org.apache.shardingsphere.proxy.backend.hbase.checker.HeterogeneousInsertStatementChecker;
import org.apache.shardingsphere.proxy.backend.hbase.checker.HeterogeneousSQLStatementChecker;
import org.apache.shardingsphere.proxy.backend.hbase.checker.HeterogeneousSelectStatementChecker;
import org.apache.shardingsphere.proxy.backend.hbase.checker.HeterogeneousUpdateStatementChecker;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;

public final class HBaseCheckerFactory {
    public static HeterogeneousSQLStatementChecker newInstance(SQLStatement sqlStatement) {
        if (sqlStatement instanceof SelectStatement) {
            return new HeterogeneousSelectStatementChecker((SelectStatement)sqlStatement);
        }
        if (sqlStatement instanceof InsertStatement) {
            return new HeterogeneousInsertStatementChecker((InsertStatement)sqlStatement);
        }
        if (sqlStatement instanceof DeleteStatement) {
            return new HeterogeneousDeleteStatementChecker((DeleteStatement)sqlStatement);
        }
        if (sqlStatement instanceof UpdateStatement) {
            return new HeterogeneousUpdateStatementChecker((UpdateStatement)sqlStatement);
        }
        return new CommonHeterogeneousSQLStatementChecker(sqlStatement);
    }

    @Generated
    private HBaseCheckerFactory() {
    }
}

