/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.hbase.checker;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.proxy.backend.hbase.checker.HeterogeneousSQLStatementChecker;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public class CommonHeterogeneousSQLStatementChecker
implements HeterogeneousSQLStatementChecker {
    protected static final List<String> ALLOW_KEYS = Arrays.asList("rowKey", "row_key", "key", "pk", "id");
    private final SQLStatement sqlStatement;

    protected final void checkIsSinglePointQuery(WhereSegment whereSegment) {
        ExpressionSegment whereExpr = whereSegment.getExpr();
        Preconditions.checkArgument((boolean)(whereExpr instanceof BinaryOperationExpression), (Object)"Only support binary operation expression.");
        BinaryOperationExpression expression = (BinaryOperationExpression)whereExpr;
        Preconditions.checkArgument((!(expression.getLeft() instanceof BinaryOperationExpression) ? 1 : 0) != 0, (Object)"Do not supported multiple expressions.");
        Preconditions.checkArgument((boolean)(expression.getLeft() instanceof ColumnSegment), (Object)"Left segment must column segment.");
        Preconditions.checkArgument((boolean)"=".equals(expression.getOperator()), (Object)"Only Supported `=` operator.");
        String rowKey = ((ColumnSegment)expression.getLeft()).getIdentifier().getValue();
        boolean isAllowKey = ALLOW_KEYS.stream().anyMatch(each -> each.equalsIgnoreCase(rowKey));
        Preconditions.checkArgument((boolean)isAllowKey, (Object)String.format("%s is not a allowed key.", rowKey));
    }

    protected final boolean isAllowExpressionSegment(ExpressionSegment expressionSegment) {
        return expressionSegment instanceof LiteralExpressionSegment || expressionSegment instanceof ParameterMarkerExpressionSegment;
    }

    protected final void checkInExpressionIsExpected(ExpressionSegment whereExpr) {
        InExpression expression = (InExpression)whereExpr;
        Preconditions.checkArgument((boolean)(expression.getLeft() instanceof ColumnSegment), (Object)"Left segment must column segment.");
        String rowKey = ((ColumnSegment)expression.getLeft()).getIdentifier().getValue();
        boolean isAllowKey = ALLOW_KEYS.stream().anyMatch(each -> each.equalsIgnoreCase(rowKey));
        Preconditions.checkArgument((boolean)isAllowKey, (Object)String.format("%s is not a allowed key.", rowKey));
        Preconditions.checkArgument((!expression.isNot() ? 1 : 0) != 0, (Object)"Do not supported `not in`.");
        Preconditions.checkArgument((boolean)(expression.getRight() instanceof ListExpression), (Object)"Only supported list expression.");
    }

    @Override
    public void execute() {
    }

    @Generated
    public CommonHeterogeneousSQLStatementChecker(SQLStatement sqlStatement) {
        this.sqlStatement = sqlStatement;
    }

    @Override
    @Generated
    public SQLStatement getSqlStatement() {
        return this.sqlStatement;
    }
}

