/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnsupportedSQLOperationException;

public final class PostgreSQLTextTimeUtils {
    private static final DateTimeFormatter POSTGRESQL_TIME_FORMATTER = DateTimeFormatter.ofPattern("[HH:mm:ss][HHmmss][HH:mm][HHmm][.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S][ ][XXXXX][XXXX][XXX][XX][X]");

    public static LocalTime parse(String value) {
        try {
            return POSTGRESQL_TIME_FORMATTER.parse((CharSequence)value, LocalTime::from);
        }
        catch (DateTimeParseException ignored) {
            throw new UnsupportedSQLOperationException("Unsupported time format: [" + value + "]");
        }
    }
}

