/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.RandomAccess;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.PostgreSQLComBindPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.execute.PostgreSQLComExecutePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.parse.PostgreSQLComParsePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierTag;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLAggregatedCommandPacket
extends PostgreSQLCommandPacket {
    private final List<PostgreSQLCommandPacket> packets;
    private final boolean containsBatchedStatements;
    private final int firstBindIndex;
    private final int lastExecuteIndex;

    public PostgreSQLAggregatedCommandPacket(List<PostgreSQLCommandPacket> packets) {
        this.packets = packets;
        int parseTimes = 0;
        int firstStatementBindTimes = 0;
        int firstStatementExecuteTimes = 0;
        String firstStatement = null;
        String firstPortal = null;
        int index = 0;
        int firstBindIndex = -1;
        int lastExecuteIndex = -1;
        for (PostgreSQLCommandPacket each : packets) {
            if (each instanceof PostgreSQLComParsePacket) {
                if (++parseTimes > 1) break;
                if (null == firstStatement) {
                    firstStatement = ((PostgreSQLComParsePacket)each).getStatementId();
                } else if (!firstStatement.equals(((PostgreSQLComParsePacket)each).getStatementId())) break;
            }
            if (each instanceof PostgreSQLComBindPacket) {
                if (-1 == firstBindIndex) {
                    firstBindIndex = index;
                }
                if (null == firstStatement) {
                    firstStatement = ((PostgreSQLComBindPacket)each).getStatementId();
                } else if (!firstStatement.equals(((PostgreSQLComBindPacket)each).getStatementId())) break;
                if (null == firstPortal) {
                    firstPortal = ((PostgreSQLComBindPacket)each).getPortal();
                } else if (!firstPortal.equals(((PostgreSQLComBindPacket)each).getPortal())) break;
                ++firstStatementBindTimes;
            }
            if (each instanceof PostgreSQLComExecutePacket) {
                if (index > lastExecuteIndex) {
                    lastExecuteIndex = index;
                }
                if (null == firstPortal) {
                    firstPortal = ((PostgreSQLComExecutePacket)each).getPortal();
                } else if (!firstPortal.equals(((PostgreSQLComExecutePacket)each).getPortal())) break;
                ++firstStatementExecuteTimes;
            }
            ++index;
        }
        this.firstBindIndex = firstBindIndex;
        this.lastExecuteIndex = lastExecuteIndex;
        this.containsBatchedStatements = firstStatementBindTimes == firstStatementExecuteTimes && firstStatementBindTimes >= 3;
        if (this.containsBatchedStatements) {
            this.ensureRandomAccessible(packets);
        }
    }

    private void ensureRandomAccessible(List<PostgreSQLCommandPacket> packets) {
        Preconditions.checkArgument((boolean)(packets instanceof RandomAccess), (Object)"Packets must be RandomAccess.");
    }

    public void write(PostgreSQLPacketPayload payload) {
    }

    @Override
    public PostgreSQLIdentifierTag getIdentifier() {
        return () -> '?';
    }

    @Generated
    public List<PostgreSQLCommandPacket> getPackets() {
        return this.packets;
    }

    @Generated
    public boolean isContainsBatchedStatements() {
        return this.containsBatchedStatements;
    }

    @Generated
    public int getFirstBindIndex() {
        return this.firstBindIndex;
    }

    @Generated
    public int getLastExecuteIndex() {
        return this.lastExecuteIndex;
    }

    @Generated
    public String toString() {
        return "PostgreSQLAggregatedCommandPacket(packets=" + this.getPackets() + ", containsBatchedStatements=" + this.isContainsBatchedStatements() + ", firstBindIndex=" + this.getFirstBindIndex() + ", lastExecuteIndex=" + this.getLastExecuteIndex() + ")";
    }
}

