/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.command.query;

import java.util.Objects;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLArrayColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLColumnType;

public final class PostgreSQLColumnDescription {
    private final String columnName;
    private final int tableOID = 0;
    private final int columnIndex;
    private final int columnLength;
    private final int typeOID;
    private final int typeModifier = -1;
    private final int dataFormat = 0;

    public PostgreSQLColumnDescription(String columnName, int columnIndex, int columnType, int columnLength, String columnTypeName) {
        this.columnName = columnName;
        this.columnIndex = columnIndex;
        this.columnLength = columnLength;
        this.typeOID = 2003 == columnType ? PostgreSQLArrayColumnType.getTypeOid(columnTypeName) : PostgreSQLColumnType.valueOfJDBCType(columnType).getValue();
    }

    @Generated
    public String getColumnName() {
        return this.columnName;
    }

    @Generated
    public int getTableOID() {
        Objects.requireNonNull(this);
        return 0;
    }

    @Generated
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Generated
    public int getColumnLength() {
        return this.columnLength;
    }

    @Generated
    public int getTypeOID() {
        return this.typeOID;
    }

    @Generated
    public int getTypeModifier() {
        return this.typeModifier;
    }

    @Generated
    public int getDataFormat() {
        Objects.requireNonNull(this);
        return 0;
    }
}

