/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.payload;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import java.nio.charset.Charset;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.payload.PacketPayload;

public final class PostgreSQLPacketPayload
implements PacketPayload {
    private final ByteBuf byteBuf;
    private final Charset charset;

    public int readInt1() {
        return this.byteBuf.readUnsignedByte();
    }

    public void writeInt1(int value) {
        this.byteBuf.writeByte(value);
    }

    public int readInt2() {
        return this.byteBuf.readUnsignedShort();
    }

    public void writeInt2(int value) {
        this.byteBuf.writeShort(value);
    }

    public int readInt4() {
        return this.byteBuf.readInt();
    }

    public void writeInt4(int value) {
        this.byteBuf.writeInt(value);
    }

    public long readInt8() {
        return this.byteBuf.readLong();
    }

    public void writeInt8(long value) {
        this.byteBuf.writeLong(value);
    }

    public void writeBytes(byte[] value) {
        this.byteBuf.writeBytes(value);
    }

    public int bytesBeforeZero() {
        return this.byteBuf.bytesBefore((byte)0);
    }

    public String readStringNul() {
        String result = this.byteBuf.readCharSequence(this.byteBuf.bytesBefore((byte)0), this.charset).toString();
        this.byteBuf.skipBytes(1);
        return result;
    }

    public void writeStringNul(String value) {
        this.byteBuf.writeBytes(value.getBytes(this.charset));
        this.byteBuf.writeByte(0);
    }

    public void writeStringEOF(String value) {
        this.byteBuf.writeBytes(value.getBytes(this.charset));
    }

    public void skipReserved(int length) {
        this.byteBuf.skipBytes(length);
    }

    public boolean hasCompletePacket() {
        return this.byteBuf.readableBytes() >= 5 && this.byteBuf.readableBytes() - 1 >= this.byteBuf.getInt(this.byteBuf.readerIndex() + 1);
    }

    public void close() {
        if (this.byteBuf instanceof CompositeByteBuf) {
            int remainBytes = this.byteBuf.readableBytes();
            if (remainBytes > 0) {
                this.byteBuf.skipBytes(remainBytes);
            }
            ((CompositeByteBuf)this.byteBuf).discardReadComponents();
        }
        this.byteBuf.release();
    }

    @Generated
    public PostgreSQLPacketPayload(ByteBuf byteBuf, Charset charset) {
        this.byteBuf = byteBuf;
        this.charset = charset;
    }

    @Generated
    public ByteBuf getByteBuf() {
        return this.byteBuf;
    }

    @Generated
    public Charset getCharset() {
        return this.charset;
    }
}

