/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.handshake;

import java.util.HashMap;
import java.util.Map;
import org.apache.shardingsphere.db.protocol.postgresql.packet.PostgreSQLPacket;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLComStartupPacket
implements PostgreSQLPacket {
    private static final String DATABASE_NAME_KEY = "database";
    private static final String USER_NAME_KEY = "user";
    private static final String CLIENT_ENCODING_KEY = "client_encoding";
    private final Map<String, String> parametersMap = new HashMap<String, String>();

    public PostgreSQLComStartupPacket(PostgreSQLPacketPayload payload) {
        payload.skipReserved(8);
        while (payload.bytesBeforeZero() > 0) {
            this.parametersMap.put(payload.readStringNul(), payload.readStringNul());
        }
    }

    public String getDatabase() {
        return this.parametersMap.get(DATABASE_NAME_KEY);
    }

    public String getUser() {
        return this.parametersMap.get(USER_NAME_KEY);
    }

    public String getClientEncoding() {
        return this.parametersMap.getOrDefault(CLIENT_ENCODING_KEY, "UTF8");
    }

    public void write(PostgreSQLPacketPayload payload) {
    }
}

