/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.parse;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierTag;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLComParsePacket
extends PostgreSQLCommandPacket {
    private final PostgreSQLPacketPayload payload;
    private final String statementId;
    private final String sql;

    public PostgreSQLComParsePacket(PostgreSQLPacketPayload payload) {
        this.payload = payload;
        payload.readInt4();
        this.statementId = payload.readStringNul();
        this.sql = payload.readStringNul();
    }

    public List<PostgreSQLColumnType> readParameterTypes() {
        int parameterCount = this.payload.readInt2();
        ArrayList<PostgreSQLColumnType> result = new ArrayList<PostgreSQLColumnType>(parameterCount);
        for (int i = 0; i < parameterCount; ++i) {
            result.add(PostgreSQLColumnType.valueOf(this.payload.readInt4()));
        }
        return result;
    }

    public void write(PostgreSQLPacketPayload payload) {
    }

    @Override
    public PostgreSQLIdentifierTag getIdentifier() {
        return PostgreSQLCommandPacketType.PARSE_COMMAND;
    }

    @Generated
    public PostgreSQLPacketPayload getPayload() {
        return this.payload;
    }

    @Generated
    public String getStatementId() {
        return this.statementId;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public String toString() {
        return "PostgreSQLComParsePacket(payload=" + this.getPayload() + ", statementId=" + this.getStatementId() + ", sql=" + this.getSql() + ")";
    }
}

