/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import lombok.Generated;

public final class PostgreSQLTextTimestampUtils {
    private static final DateTimeFormatter POSTGRESQL_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("[yyyy-MM-dd][yyyy_MM_dd][yyyyMMdd][yyyy-M-d][MM/dd/yy][yyMMdd]['T'][ ][HH:mm:ss][HHmmss][HH:mm][HHmm][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S][ ][XXXXX][XXXX][XXX][XX][X]");

    public static Timestamp parse(String value) {
        try {
            return Timestamp.valueOf(LocalDateTime.from(POSTGRESQL_DATE_TIME_FORMATTER.parse(value)));
        }
        catch (DateTimeParseException ignored) {
            return Timestamp.valueOf(value);
        }
    }

    @Generated
    private PostgreSQLTextTimestampUtils() {
    }
}

