/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import lombok.Generated;

public final class PostgreSQLByteConverter {
    private static final short NUMERIC_POS = 0;
    private static final short NUMERIC_NEG = 16384;
    private static final short NUMERIC_NAN = -16384;
    private static final int[] INT_TEN_POWERS;
    private static final BigInteger[] BI_TEN_POWERS;
    private static final BigInteger BI_TEN_THOUSAND;

    public static Number numeric(byte[] bytes) {
        return PostgreSQLByteConverter.numeric(bytes, 0);
    }

    public static Number numeric(byte[] bytes, int pos) {
        short sign = PostgreSQLByteConverter.readShort2(bytes, pos + 4);
        Preconditions.checkArgument((0 == sign || 16384 == sign || -16384 == sign ? 1 : 0) != 0, (Object)"invalid sign in \"numeric\" value");
        short scale = PostgreSQLByteConverter.readShort2(bytes, pos + 6);
        Preconditions.checkArgument(((scale & 0x3FFF) == scale ? 1 : 0) != 0, (Object)"invalid scale in \"numeric\" value");
        if (-16384 == sign) {
            return Double.NaN;
        }
        short len = PostgreSQLByteConverter.readShort2(bytes, pos);
        if (0 == len) {
            return new BigDecimal(BigInteger.ZERO, scale);
        }
        short weight = PostgreSQLByteConverter.readShort2(bytes, pos + 2);
        if (weight < 0) {
            weight = (short)(weight + 1);
            return PostgreSQLByteConverter.initBigDecimalNoneWeight(bytes, pos, len, weight, sign, scale);
        }
        return 0 == scale ? (Number)PostgreSQLByteConverter.initBigDecimalNoneScale(bytes, pos, len, weight, sign) : (Number)PostgreSQLByteConverter.initBigDecimal(bytes, pos, len, weight, sign, scale);
    }

    public static byte[] numeric(BigDecimal number) {
        BigInteger unscaled = number.unscaledValue().abs();
        int scale = number.scale();
        if (BigInteger.ZERO.equals(unscaled)) {
            return PostgreSQLByteConverter.initBytesZeroCase(scale);
        }
        PositiveShortStack shortStacks = new PositiveShortStack();
        int weight = -1;
        if (scale < 0) {
            scale = Math.abs(scale);
            weight += scale / 4;
            int mod = scale % 4;
            unscaled = unscaled.multiply(PostgreSQLByteConverter.tenPower(mod));
            scale = 0;
        }
        weight = 0 == scale ? PostgreSQLByteConverter.initShortValuesNoneScaled(shortStacks, unscaled, weight) : PostgreSQLByteConverter.initShortValuesScaled(shortStacks, unscaled, scale);
        return PostgreSQLByteConverter.initBytes(number, shortStacks, scale, weight);
    }

    private static byte[] initBytesZeroCase(int scale) {
        byte[] result = new byte[]{0, 0, -1, -1, 0, 0, 0, 0};
        PostgreSQLByteConverter.int2(result, 6, Math.max(0, scale));
        return result;
    }

    private static int initShortValuesNoneScaled(PositiveShortStack shortStacks, BigInteger unscaled, int weight) {
        int result = weight;
        BigInteger tempUnscaled = unscaled;
        BigInteger maxInteger = BigInteger.valueOf(Long.MAX_VALUE);
        while (unscaled.compareTo(maxInteger) > 0) {
            BigInteger[] pair = unscaled.divideAndRemainder(BI_TEN_THOUSAND);
            tempUnscaled = pair[0];
            shortStacks.push(pair[1].shortValue());
            ++result;
        }
        long unscaledLong = tempUnscaled.longValueExact();
        do {
            shortStacks.push((short)(unscaledLong % 10000L));
            ++result;
        } while (0L != (unscaledLong /= 10000L));
        return result;
    }

    private static int initShortValuesScaled(PositiveShortStack shortStacks, BigInteger unscaled, int scale) {
        int result = -1;
        BigInteger[] split = unscaled.divideAndRemainder(PostgreSQLByteConverter.tenPower(scale));
        BigInteger decimal = split[1];
        BigInteger wholes = split[0];
        if (!BigInteger.ZERO.equals(decimal)) {
            int mod = scale % 4;
            int segments = scale / 4;
            if (0 != mod) {
                decimal = decimal.multiply(PostgreSQLByteConverter.tenPower(4 - mod));
                ++segments;
            }
            do {
                BigInteger[] pair = decimal.divideAndRemainder(BI_TEN_THOUSAND);
                decimal = pair[0];
                shortStacks.push(pair[1].shortValue());
                --segments;
            } while (!BigInteger.ZERO.equals(decimal));
            if (BigInteger.ZERO.equals(wholes)) {
                result -= segments;
            } else {
                for (int i = 0; i < segments; ++i) {
                    shortStacks.push((short)0);
                }
            }
        }
        while (!BigInteger.ZERO.equals(wholes)) {
            ++result;
            BigInteger[] pair = wholes.divideAndRemainder(BI_TEN_THOUSAND);
            wholes = pair[0];
            shortStacks.push(pair[1].shortValue());
        }
        return result;
    }

    private static byte[] initBytes(BigDecimal number, PositiveShortStack shortStacks, int scale, int weight) {
        short s;
        byte[] result = new byte[8 + 2 * shortStacks.size()];
        int idx = 0;
        PostgreSQLByteConverter.int2(result, idx, shortStacks.size());
        PostgreSQLByteConverter.int2(result, idx += 2, weight);
        PostgreSQLByteConverter.int2(result, idx += 2, number.signum() == -1 ? 16384 : 0);
        PostgreSQLByteConverter.int2(result, idx += 2, Math.max(0, scale));
        idx += 2;
        while ((s = shortStacks.pop()) != -1) {
            PostgreSQLByteConverter.int2(result, idx, s);
            idx += 2;
        }
        return result;
    }

    private static void int2(byte[] target, int idx, int value) {
        target[idx] = (byte)(value >>> 8);
        target[idx + 1] = (byte)value;
    }

    private static Number initBigDecimalNoneWeight(byte[] bytes, int pos, short len, short weight, short sign, short scale) {
        int idx = pos + 8;
        short d = PostgreSQLByteConverter.readShort2(bytes, idx);
        assert (scale > 0);
        int effectiveScale = scale;
        if (weight < 0) {
            effectiveScale += 4 * weight;
        }
        for (int i = 1; i < len && 0 == d; ++i) {
            effectiveScale -= 4;
            d = PostgreSQLByteConverter.readShort2(bytes, idx += 2);
        }
        assert (effectiveScale > 0);
        if (effectiveScale >= 4) {
            effectiveScale -= 4;
        } else {
            d = (short)(d / INT_TEN_POWERS[4 - effectiveScale]);
            effectiveScale = 0;
        }
        BigInteger unscaledBI = null;
        long unscaledInt = d;
        for (int i = 1; i < len; ++i) {
            if (i == 4 && effectiveScale > 2) {
                unscaledBI = BigInteger.valueOf(unscaledInt);
            }
            d = PostgreSQLByteConverter.readShort2(bytes, idx += 2);
            if (effectiveScale >= 4) {
                if (null == unscaledBI) {
                    unscaledInt *= 10000L;
                } else {
                    unscaledBI = unscaledBI.multiply(BI_TEN_THOUSAND);
                }
                effectiveScale -= 4;
            } else {
                if (null == unscaledBI) {
                    unscaledInt *= (long)INT_TEN_POWERS[effectiveScale];
                } else {
                    unscaledBI = unscaledBI.multiply(PostgreSQLByteConverter.tenPower(effectiveScale));
                }
                d = (short)(d / INT_TEN_POWERS[4 - effectiveScale]);
                effectiveScale = 0;
            }
            if (null == unscaledBI) {
                unscaledInt += (long)d;
                continue;
            }
            if (0 == d) continue;
            unscaledBI = unscaledBI.add(BigInteger.valueOf(d));
        }
        if (null == unscaledBI) {
            unscaledBI = BigInteger.valueOf(unscaledInt);
        }
        if (effectiveScale > 0) {
            unscaledBI = unscaledBI.multiply(PostgreSQLByteConverter.tenPower(effectiveScale));
        }
        if (16384 == sign) {
            unscaledBI = unscaledBI.negate();
        }
        return new BigDecimal(unscaledBI, scale);
    }

    private static Number initBigDecimalNoneScale(byte[] bytes, int pos, short len, short weight, short sign) {
        int bigDecScale;
        int idx = pos + 8;
        short d = PostgreSQLByteConverter.readShort2(bytes, idx);
        BigInteger unscaledBI = null;
        long unscaledInt = d;
        for (int i = 1; i < len; ++i) {
            if (i == 4) {
                unscaledBI = BigInteger.valueOf(unscaledInt);
            }
            d = PostgreSQLByteConverter.readShort2(bytes, idx += 2);
            if (null == unscaledBI) {
                unscaledInt *= 10000L;
                unscaledInt += (long)d;
                continue;
            }
            unscaledBI = unscaledBI.multiply(BI_TEN_THOUSAND);
            if (0 == d) continue;
            unscaledBI = unscaledBI.add(BigInteger.valueOf(d));
        }
        if (null == unscaledBI) {
            unscaledBI = BigInteger.valueOf(unscaledInt);
        }
        if (16384 == sign) {
            unscaledBI = unscaledBI.negate();
        }
        return 0 == (bigDecScale = (len - (weight + 1)) * 4) ? new BigDecimal(unscaledBI) : new BigDecimal(unscaledBI, bigDecScale);
    }

    private static Number initBigDecimal(byte[] bytes, int pos, short len, short weight, short sign, short scale) {
        int idx = pos + 8;
        short d = PostgreSQLByteConverter.readShort2(bytes, idx);
        BigInteger unscaledBI = null;
        long unscaledInt = d;
        int effectiveWeight = weight;
        int effectiveScale = scale;
        for (int i = 1; i < len; ++i) {
            if (i == 4) {
                unscaledBI = BigInteger.valueOf(unscaledInt);
            }
            d = PostgreSQLByteConverter.readShort2(bytes, idx += 2);
            if (effectiveWeight > 0) {
                --effectiveWeight;
                if (null == unscaledBI) {
                    unscaledInt *= 10000L;
                } else {
                    unscaledBI = unscaledBI.multiply(BI_TEN_THOUSAND);
                }
            } else if (effectiveScale >= 4) {
                effectiveScale -= 4;
                if (null == unscaledBI) {
                    unscaledInt *= 10000L;
                } else {
                    unscaledBI = unscaledBI.multiply(BI_TEN_THOUSAND);
                }
            } else {
                if (null == unscaledBI) {
                    unscaledInt *= (long)INT_TEN_POWERS[effectiveScale];
                } else {
                    unscaledBI = unscaledBI.multiply(PostgreSQLByteConverter.tenPower(effectiveScale));
                }
                d = (short)(d / INT_TEN_POWERS[4 - effectiveScale]);
                effectiveScale = 0;
            }
            if (null == unscaledBI) {
                unscaledInt += (long)d;
                continue;
            }
            if (0 == d) continue;
            unscaledBI = unscaledBI.add(BigInteger.valueOf(d));
        }
        if (null == unscaledBI) {
            unscaledBI = BigInteger.valueOf(unscaledInt);
        }
        if (effectiveWeight > 0) {
            unscaledBI = unscaledBI.multiply(PostgreSQLByteConverter.tenPower(effectiveWeight * 4));
        }
        if (effectiveScale > 0) {
            unscaledBI = unscaledBI.multiply(PostgreSQLByteConverter.tenPower(effectiveScale));
        }
        if (16384 == sign) {
            unscaledBI = unscaledBI.negate();
        }
        return new BigDecimal(unscaledBI, scale);
    }

    private static BigInteger tenPower(int exponent) {
        return BI_TEN_POWERS.length > exponent ? BI_TEN_POWERS[exponent] : BigInteger.TEN.pow(exponent);
    }

    private static short readShort2(byte[] bytes, int index) {
        return (short)(((bytes[index] & 0xFF) << 8) + (bytes[index + 1] & 0xFF));
    }

    @Generated
    private PostgreSQLByteConverter() {
    }

    static {
        int i;
        INT_TEN_POWERS = new int[6];
        BI_TEN_POWERS = new BigInteger[32];
        BI_TEN_THOUSAND = BigInteger.valueOf(10000L);
        for (i = 0; i < INT_TEN_POWERS.length; ++i) {
            PostgreSQLByteConverter.INT_TEN_POWERS[i] = (int)Math.pow(10.0, i);
        }
        for (i = 0; i < BI_TEN_POWERS.length; ++i) {
            PostgreSQLByteConverter.BI_TEN_POWERS[i] = BigInteger.TEN.pow(i);
        }
    }

    private static final class PositiveShortStack {
        private short[] shorts = new short[8];
        private int index;

        private PositiveShortStack() {
        }

        public void push(short value) {
            if (0 != value || 0 != this.index) {
                Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (String)"only non-negative values accepted: %s", (int)value);
                if (this.index == this.shorts.length) {
                    this.grow();
                }
                this.shorts[this.index++] = value;
            }
        }

        public int size() {
            return this.index;
        }

        public boolean isEmpty() {
            return 0 == this.index;
        }

        public short pop() {
            return this.index > 0 ? this.shorts[--this.index] : (short)-1;
        }

        private void grow() {
            int newSize = this.shorts.length <= 1024 ? this.shorts.length << 1 : (int)((double)this.shorts.length * 1.5);
            this.shorts = Arrays.copyOf(this.shorts, newSize);
        }
    }
}

