/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.binary.BinaryColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLBoolArrayBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLDateBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLDoubleBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLFloat4ArrayBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLFloat8ArrayBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLFloatBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLInt2ArrayBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLInt2BinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLInt4ArrayBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLInt4BinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLInt8ArrayBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLInt8BinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLNumericBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLStringArrayBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLStringBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLTimeBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLUnspecifiedBinaryProtocolValue;

public final class PostgreSQLBinaryProtocolValueFactory {
    private static final Map<BinaryColumnType, PostgreSQLBinaryProtocolValue> BINARY_PROTOCOL_VALUES = new HashMap<BinaryColumnType, PostgreSQLBinaryProtocolValue>();

    private static void setUnspecifiedBinaryProtocolValue() {
        PostgreSQLUnspecifiedBinaryProtocolValue binaryProtocolValue = new PostgreSQLUnspecifiedBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_UNSPECIFIED, binaryProtocolValue);
    }

    private static void setStringLenencBinaryProtocolValue() {
        PostgreSQLStringBinaryProtocolValue binaryProtocolValue = new PostgreSQLStringBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_VARCHAR, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_CHAR, binaryProtocolValue);
    }

    private static void setInt8BinaryProtocolValue() {
        PostgreSQLInt8BinaryProtocolValue binaryProtocolValue = new PostgreSQLInt8BinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_INT8, binaryProtocolValue);
    }

    private static void setInt4BinaryProtocolValue() {
        PostgreSQLInt4BinaryProtocolValue binaryProtocolValue = new PostgreSQLInt4BinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_INT4, binaryProtocolValue);
    }

    private static void setInt2BinaryProtocolValue() {
        PostgreSQLInt2BinaryProtocolValue binaryProtocolValue = new PostgreSQLInt2BinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_INT2, binaryProtocolValue);
    }

    private static void setDoubleBinaryProtocolValue() {
        PostgreSQLDoubleBinaryProtocolValue binaryProtocolValue = new PostgreSQLDoubleBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_FLOAT8, binaryProtocolValue);
    }

    private static void setFloatBinaryProtocolValue() {
        PostgreSQLFloatBinaryProtocolValue binaryProtocolValue = new PostgreSQLFloatBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_FLOAT4, binaryProtocolValue);
    }

    private static void setNumericBinaryProtocolValue() {
        PostgreSQLNumericBinaryProtocolValue binaryProtocolValue = new PostgreSQLNumericBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_NUMERIC, binaryProtocolValue);
    }

    private static void setDateBinaryProtocolValue() {
        PostgreSQLDateBinaryProtocolValue binaryProtocolValue = new PostgreSQLDateBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_DATE, binaryProtocolValue);
    }

    private static void setTimeBinaryProtocolValue() {
        PostgreSQLTimeBinaryProtocolValue binaryProtocolValue = new PostgreSQLTimeBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_TIMESTAMP, binaryProtocolValue);
    }

    private static void setInt2ArrayBinaryProtocolValue() {
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_INT2_ARRAY, new PostgreSQLInt2ArrayBinaryProtocolValue());
    }

    private static void setInt4ArrayBinaryProtocolValue() {
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_INT4_ARRAY, new PostgreSQLInt4ArrayBinaryProtocolValue());
    }

    private static void setInt8ArrayBinaryProtocolValue() {
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_INT8_ARRAY, new PostgreSQLInt8ArrayBinaryProtocolValue());
    }

    private static void setFloat4ArrayBinaryProtocolValue() {
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_FLOAT4_ARRAY, new PostgreSQLFloat4ArrayBinaryProtocolValue());
    }

    private static void setFloat8ArrayBinaryProtocolValue() {
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_FLOAT8_ARRAY, new PostgreSQLFloat8ArrayBinaryProtocolValue());
    }

    private static void setBoolArrayBinaryProtocolValue() {
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_BOOL_ARRAY, new PostgreSQLBoolArrayBinaryProtocolValue());
    }

    private static void setStringArrayBinaryProtocolValue() {
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_VARCHAR_ARRAY, new PostgreSQLStringArrayBinaryProtocolValue());
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_CHAR_ARRAY, new PostgreSQLStringArrayBinaryProtocolValue());
        BINARY_PROTOCOL_VALUES.put(PostgreSQLColumnType.POSTGRESQL_TYPE_TEXT_ARRAY, new PostgreSQLStringArrayBinaryProtocolValue());
    }

    public static PostgreSQLBinaryProtocolValue getBinaryProtocolValue(BinaryColumnType binaryColumnType) {
        Preconditions.checkArgument((boolean)BINARY_PROTOCOL_VALUES.containsKey(binaryColumnType), (String)"Cannot find PostgreSQL type '%s' in column type when process binary protocol value", (Object)binaryColumnType);
        return BINARY_PROTOCOL_VALUES.get(binaryColumnType);
    }

    @Generated
    private PostgreSQLBinaryProtocolValueFactory() {
    }

    static {
        PostgreSQLBinaryProtocolValueFactory.setUnspecifiedBinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setStringLenencBinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setInt8BinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setInt4BinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setInt2BinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setDoubleBinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setFloatBinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setNumericBinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setDateBinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setTimeBinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setInt2ArrayBinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setInt4ArrayBinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setInt8ArrayBinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setFloat4ArrayBinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setFloat8ArrayBinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setBoolArrayBinaryProtocolValue();
        PostgreSQLBinaryProtocolValueFactory.setStringArrayBinaryProtocolValue();
    }
}

