/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnsupportedSQLOperationException;

public final class PostgreSQLArrayParameterDecoder {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public short[] decodeInt2Array(byte[] parameterBytes, boolean isBinary) {
        ShardingSpherePreconditions.checkState((!isBinary ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("binary mode"));
        String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
        Collection<String> parameterElements = this.decodeText(parameterValue);
        short[] result = new short[parameterElements.size()];
        int index = 0;
        for (String element : parameterElements) {
            result[index++] = Short.parseShort(element);
        }
        return result;
    }

    public int[] decodeInt4Array(byte[] parameterBytes, boolean isBinary) {
        ShardingSpherePreconditions.checkState((!isBinary ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("binary mode"));
        String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
        Collection<String> parameterElements = this.decodeText(parameterValue);
        int[] result = new int[parameterElements.size()];
        int index = 0;
        for (String element : parameterElements) {
            result[index++] = Integer.parseInt(element);
        }
        return result;
    }

    public long[] decodeInt8Array(byte[] parameterBytes, boolean isBinary) {
        ShardingSpherePreconditions.checkState((!isBinary ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("binary mode"));
        String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
        Collection<String> parameterElements = this.decodeText(parameterValue);
        long[] result = new long[parameterElements.size()];
        int index = 0;
        for (String element : parameterElements) {
            result[index++] = Long.parseLong(element);
        }
        return result;
    }

    public float[] decodeFloat4Array(byte[] parameterBytes, boolean isBinary) {
        ShardingSpherePreconditions.checkState((!isBinary ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("binary mode"));
        String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
        Collection<String> parameterElements = this.decodeText(parameterValue);
        float[] result = new float[parameterElements.size()];
        int index = 0;
        for (String element : parameterElements) {
            result[index++] = Float.parseFloat(element);
        }
        return result;
    }

    public double[] decodeFloat8Array(byte[] parameterBytes, boolean isBinary) {
        ShardingSpherePreconditions.checkState((!isBinary ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("binary mode"));
        String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
        Collection<String> parameterElements = this.decodeText(parameterValue);
        double[] result = new double[parameterElements.size()];
        int index = 0;
        for (String element : parameterElements) {
            result[index++] = Double.parseDouble(element);
        }
        return result;
    }

    public boolean[] decodeBoolArray(byte[] parameterBytes, boolean isBinary) {
        ShardingSpherePreconditions.checkState((!isBinary ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("binary mode"));
        String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
        Collection<String> parameterElements = this.decodeText(parameterValue);
        boolean[] result = new boolean[parameterElements.size()];
        int index = 0;
        for (String element : parameterElements) {
            result[index++] = Boolean.parseBoolean(element);
        }
        return result;
    }

    public String[] decodeStringArray(byte[] parameterBytes, boolean isBinary) {
        ShardingSpherePreconditions.checkState((!isBinary ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("binary mode"));
        String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
        Collection<String> parameterElements = this.decodeText(parameterValue);
        return parameterElements.toArray(EMPTY_STRING_ARRAY);
    }

    private Collection<String> decodeText(String value) {
        Preconditions.checkArgument((value.length() >= 2 ? 1 : 0) != 0, (Object)"value length less than 2");
        Preconditions.checkArgument(('{' == value.charAt(0) && '}' == value.charAt(value.length() - 1) ? 1 : 0) != 0, (Object)"value not start with '{' or not end with '}'");
        String[] elements = value.substring(1, value.length() - 1).split(",");
        return Arrays.stream(elements).map(each -> {
            if ("NULL".equals(each)) {
                return null;
            }
            if ('\"' == each.charAt(0) && '\"' == each.charAt(each.length() - 1)) {
                each = each.substring(1, each.length() - 1);
            }
            while (each.contains("\\\"")) {
                each = each.replace("\\\"", "\"");
            }
            while (each.contains("\\\\")) {
                each = each.replace("\\\\", "\\");
            }
            return each;
        }).collect(Collectors.toCollection(ArrayList::new));
    }
}

