/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLValueFormat;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.PostgreSQLTypeUnspecifiedSQLParameter;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLBinaryProtocolValueFactory;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLTextTimestampUtils;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierTag;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLComBindPacket
extends PostgreSQLCommandPacket {
    private final PostgreSQLPacketPayload payload;
    private final String portal;
    private final String statementId;

    public PostgreSQLComBindPacket(PostgreSQLPacketPayload payload) {
        this.payload = payload;
        payload.readInt4();
        this.portal = payload.readStringNul();
        this.statementId = payload.readStringNul();
    }

    public List<Object> readParameters(List<PostgreSQLColumnType> parameterTypes) {
        int parameterFormatCount = this.payload.readInt2();
        ArrayList<Integer> parameterFormats = new ArrayList<Integer>(parameterFormatCount);
        for (int i = 0; i < parameterFormatCount; ++i) {
            parameterFormats.add(this.payload.readInt2());
        }
        int parameterCount = this.payload.readInt2();
        ArrayList<Object> result = new ArrayList<Object>(parameterCount);
        for (int parameterIndex = 0; parameterIndex < parameterCount; ++parameterIndex) {
            int parameterValueLength = this.payload.readInt4();
            if (-1 == parameterValueLength) {
                result.add(null);
                continue;
            }
            Object parameterValue = this.isTextParameterValue(parameterFormats, parameterIndex) ? this.getTextParameters(this.payload, parameterValueLength, parameterTypes.get(parameterIndex)) : this.getBinaryParameters(this.payload, parameterValueLength, parameterTypes.get(parameterIndex));
            result.add(parameterValue);
        }
        return result;
    }

    private boolean isTextParameterValue(List<Integer> parameterFormats, int parameterIndex) {
        if (parameterFormats.isEmpty()) {
            return true;
        }
        if (1 == parameterFormats.size()) {
            return 0 == parameterFormats.get(0);
        }
        return 0 == parameterFormats.get(parameterIndex);
    }

    private Object getTextParameters(PostgreSQLPacketPayload payload, int parameterValueLength, PostgreSQLColumnType parameterType) {
        String value = payload.getByteBuf().readCharSequence(parameterValueLength, payload.getCharset()).toString();
        return this.getTextParameters(value, parameterType);
    }

    private Object getTextParameters(String textValue, PostgreSQLColumnType parameterType) {
        switch (parameterType) {
            case POSTGRESQL_TYPE_UNSPECIFIED: {
                return new PostgreSQLTypeUnspecifiedSQLParameter(textValue);
            }
            case POSTGRESQL_TYPE_BOOL: {
                return Boolean.valueOf(textValue);
            }
            case POSTGRESQL_TYPE_INT2: 
            case POSTGRESQL_TYPE_INT4: {
                return Integer.parseInt(textValue);
            }
            case POSTGRESQL_TYPE_INT8: {
                return Long.parseLong(textValue);
            }
            case POSTGRESQL_TYPE_FLOAT4: {
                return Float.valueOf(Float.parseFloat(textValue));
            }
            case POSTGRESQL_TYPE_FLOAT8: {
                return Double.parseDouble(textValue);
            }
            case POSTGRESQL_TYPE_NUMERIC: {
                try {
                    return Integer.parseInt(textValue);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return Long.parseLong(textValue);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        return new BigDecimal(textValue);
                    }
                }
            }
            case POSTGRESQL_TYPE_DATE: {
                return Date.valueOf(textValue);
            }
            case POSTGRESQL_TYPE_TIME: {
                return Time.valueOf(textValue);
            }
            case POSTGRESQL_TYPE_TIMESTAMP: 
            case POSTGRESQL_TYPE_TIMESTAMPTZ: {
                return PostgreSQLTextTimestampUtils.parse(textValue);
            }
        }
        return textValue;
    }

    private Object getBinaryParameters(PostgreSQLPacketPayload payload, int parameterValueLength, PostgreSQLColumnType parameterType) {
        PostgreSQLBinaryProtocolValue binaryProtocolValue = PostgreSQLBinaryProtocolValueFactory.getBinaryProtocolValue(parameterType);
        return binaryProtocolValue.read(payload, parameterValueLength);
    }

    public List<PostgreSQLValueFormat> readResultFormats() {
        int resultFormatsLength = this.payload.readInt2();
        if (0 == resultFormatsLength) {
            return Collections.emptyList();
        }
        if (1 == resultFormatsLength) {
            return Collections.singletonList(PostgreSQLValueFormat.valueOf(this.payload.readInt2()));
        }
        ArrayList<PostgreSQLValueFormat> result = new ArrayList<PostgreSQLValueFormat>(resultFormatsLength);
        for (int i = 0; i < resultFormatsLength; ++i) {
            result.add(PostgreSQLValueFormat.valueOf(this.payload.readInt2()));
        }
        return result;
    }

    public void write(PostgreSQLPacketPayload payload) {
    }

    @Override
    public PostgreSQLIdentifierTag getIdentifier() {
        return PostgreSQLCommandPacketType.BIND_COMMAND;
    }

    @Generated
    public PostgreSQLPacketPayload getPayload() {
        return this.payload;
    }

    @Generated
    public String getPortal() {
        return this.portal;
    }

    @Generated
    public String getStatementId() {
        return this.statementId;
    }

    @Generated
    public String toString() {
        return "PostgreSQLComBindPacket(payload=" + this.getPayload() + ", portal=" + this.getPortal() + ", statementId=" + this.getStatementId() + ")";
    }
}

