/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.spring.namespace.parser;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.shardingsphere.driver.jdbc.core.datasource.ShardingSphereDataSource;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class DataSourceBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(ShardingSphereDataSource.class);
        factory.addConstructorArgValue((Object)this.parseSchemaName(element));
        factory.addConstructorArgValue((Object)this.parseModeConfiguration(element));
        if (!StringUtils.isEmpty((Object)element.getAttribute("data-source-names"))) {
            factory.addConstructorArgValue(this.parseDataSources(element));
            factory.addConstructorArgValue(this.parseRuleConfigurations(element));
            factory.addConstructorArgValue((Object)this.parseProperties(element, parserContext));
        }
        factory.setDestroyMethodName("close");
        return factory.getBeanDefinition();
    }

    private String parseSchemaName(Element element) {
        return element.getAttribute("schema-name");
    }

    private BeanDefinition parseModeConfiguration(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(ModeConfiguration.class);
        Element modeElement = DomUtils.getChildElementByTagName((Element)element, (String)"mode");
        if (null == modeElement) {
            this.addDefaultModeConfiguration(factory);
        } else {
            this.addConfiguredModeConfiguration(factory, modeElement);
        }
        return factory.getBeanDefinition();
    }

    private void addDefaultModeConfiguration(BeanDefinitionBuilder factory) {
        factory.addConstructorArgValue((Object)"Memory");
        factory.addConstructorArgValue(null);
        factory.addConstructorArgValue((Object)true);
    }

    private void addConfiguredModeConfiguration(BeanDefinitionBuilder factory, Element modeElement) {
        factory.addConstructorArgValue((Object)modeElement.getAttribute("type"));
        if (null == modeElement.getAttribute("repository-ref")) {
            factory.addConstructorArgValue(null);
        } else {
            factory.addConstructorArgReference(modeElement.getAttribute("repository-ref"));
        }
        factory.addConstructorArgValue((Object)modeElement.getAttribute("overwrite"));
    }

    private Map<String, RuntimeBeanReference> parseDataSources(Element element) {
        List dataSources = Splitter.on((String)",").trimResults().splitToList((CharSequence)element.getAttribute("data-source-names"));
        ManagedMap result = new ManagedMap(dataSources.size());
        for (String each : dataSources) {
            result.put(each, new RuntimeBeanReference(each));
        }
        return result;
    }

    private Collection<RuntimeBeanReference> parseRuleConfigurations(Element element) {
        List ruleIdList = Splitter.on((String)",").trimResults().splitToList((CharSequence)element.getAttribute("rule-refs"));
        ManagedList result = new ManagedList(ruleIdList.size());
        for (String each : ruleIdList) {
            result.add(new RuntimeBeanReference(each));
        }
        return result;
    }

    private Properties parseProperties(Element element, ParserContext parserContext) {
        Element propsElement = DomUtils.getChildElementByTagName((Element)element, (String)"props");
        return null == propsElement ? new Properties() : parserContext.getDelegate().parsePropsElement(propsElement);
    }
}

