/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.governance.context.transaction;

import com.google.common.eventbus.Subscribe;
import java.util.Map;
import org.apache.shardingsphere.governance.core.event.GovernanceEventBus;
import org.apache.shardingsphere.governance.core.event.model.datasource.DataSourceChangeCompletedEvent;
import org.apache.shardingsphere.transaction.ShardingTransactionManagerEngine;
import org.apache.shardingsphere.transaction.context.TransactionContexts;

public final class GovernanceTransactionContexts
implements TransactionContexts {
    private final TransactionContexts contexts;

    public GovernanceTransactionContexts(TransactionContexts contexts) {
        this.contexts = contexts;
        GovernanceEventBus.getInstance().register((Object)this);
    }

    public Map<String, ShardingTransactionManagerEngine> getEngines() {
        return this.contexts.getEngines();
    }

    public ShardingTransactionManagerEngine getDefaultTransactionManagerEngine() {
        return this.contexts.getDefaultTransactionManagerEngine();
    }

    public void close() throws Exception {
        this.contexts.close();
    }

    @Subscribe
    public synchronized void renew(DataSourceChangeCompletedEvent event) throws Exception {
        ShardingTransactionManagerEngine oldEngine = (ShardingTransactionManagerEngine)this.contexts.getEngines().remove(event.getSchemaName());
        if (null != oldEngine) {
            oldEngine.close();
        }
        ShardingTransactionManagerEngine newEngine = new ShardingTransactionManagerEngine();
        newEngine.init(event.getDatabaseType(), event.getDataSources());
        this.contexts.getEngines().put(event.getSchemaName(), newEngine);
    }
}

