/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.governance.context.schema;

import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.governance.core.event.GovernanceEventBus;
import org.apache.shardingsphere.governance.core.event.model.auth.AuthenticationChangedEvent;
import org.apache.shardingsphere.governance.core.event.model.datasource.DataSourceChangeCompletedEvent;
import org.apache.shardingsphere.governance.core.event.model.datasource.DataSourceChangedEvent;
import org.apache.shardingsphere.governance.core.event.model.metadata.MetaDataChangedEvent;
import org.apache.shardingsphere.governance.core.event.model.props.PropertiesChangedEvent;
import org.apache.shardingsphere.governance.core.event.model.rule.RuleConfigurationsChangedEvent;
import org.apache.shardingsphere.governance.core.event.model.schema.SchemaAddedEvent;
import org.apache.shardingsphere.governance.core.event.model.schema.SchemaDeletedEvent;
import org.apache.shardingsphere.governance.core.facade.GovernanceFacade;
import org.apache.shardingsphere.governance.core.registry.event.CircuitStateChangedEvent;
import org.apache.shardingsphere.governance.core.registry.event.DisabledStateChangedEvent;
import org.apache.shardingsphere.governance.core.registry.schema.GovernanceSchema;
import org.apache.shardingsphere.infra.auth.Authentication;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConverter;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.schema.SchemaContexts;
import org.apache.shardingsphere.infra.context.schema.SchemaContextsBuilder;
import org.apache.shardingsphere.infra.context.schema.impl.StandardSchemaContexts;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorKernel;
import org.apache.shardingsphere.infra.metadata.model.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.model.logic.LogicSchemaMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.StatusContainedRule;
import org.apache.shardingsphere.infra.rule.event.RuleChangedEvent;
import org.apache.shardingsphere.infra.rule.event.impl.DataSourceNameDisabledEvent;
import org.apache.shardingsphere.infra.schema.ShardingSphereSchema;

public final class GovernanceSchemaContexts
implements SchemaContexts {
    private final GovernanceFacade governanceFacade;
    private volatile SchemaContexts schemaContexts;

    public GovernanceSchemaContexts(SchemaContexts schemaContexts, GovernanceFacade governanceFacade) {
        this.governanceFacade = governanceFacade;
        this.schemaContexts = schemaContexts;
        GovernanceEventBus.getInstance().register((Object)this);
        this.disableDataSources();
        this.persistMetaData();
    }

    private void disableDataSources() {
        this.schemaContexts.getSchemas().forEach((key, value) -> value.getRules().stream().filter(each -> each instanceof StatusContainedRule).forEach(each -> this.disableDataSources((String)key, (StatusContainedRule)each)));
    }

    private void disableDataSources(String schemaName, StatusContainedRule rule) {
        Collection disabledDataSources = this.governanceFacade.getRegistryCenter().loadDisabledDataSources(schemaName);
        disabledDataSources.stream().map(this::getDataSourceName).forEach(each -> rule.updateRuleStatus((RuleChangedEvent)new DataSourceNameDisabledEvent(each, true)));
    }

    private String getDataSourceName(String disabledDataSource) {
        return new GovernanceSchema(disabledDataSource).getDataSourceName();
    }

    private void persistMetaData() {
        this.schemaContexts.getSchemas().forEach((key, value) -> this.governanceFacade.getConfigCenter().persistMetaData(key, value.getMetaData().getSchemaMetaData()));
    }

    public DatabaseType getDatabaseType() {
        return this.schemaContexts.getDatabaseType();
    }

    private DatabaseType getDatabaseType(Map<String, Map<String, DataSource>> dataSourcesMap) throws SQLException {
        if (dataSourcesMap.isEmpty() || dataSourcesMap.values().iterator().next().isEmpty()) {
            return this.schemaContexts.getDatabaseType();
        }
        DataSource dataSource = dataSourcesMap.values().iterator().next().values().iterator().next();
        try (Connection connection = dataSource.getConnection();){
            DatabaseType databaseType = DatabaseTypeRegistry.getDatabaseTypeByURL((String)connection.getMetaData().getURL());
            return databaseType;
        }
    }

    public Map<String, ShardingSphereSchema> getSchemas() {
        return this.schemaContexts.getSchemas();
    }

    public ShardingSphereSchema getDefaultSchema() {
        return this.schemaContexts.getDefaultSchema();
    }

    public ExecutorKernel getExecutorKernel() {
        return this.schemaContexts.getExecutorKernel();
    }

    public Authentication getAuthentication() {
        return this.schemaContexts.getAuthentication();
    }

    public ConfigurationProperties getProps() {
        return this.schemaContexts.getProps();
    }

    public boolean isCircuitBreak() {
        return this.schemaContexts.isCircuitBreak();
    }

    public void close() throws IOException {
        this.schemaContexts.close();
        this.governanceFacade.close();
    }

    @Subscribe
    public synchronized void renew(SchemaAddedEvent event) throws SQLException {
        HashMap<String, ShardingSphereSchema> schemas = new HashMap<String, ShardingSphereSchema>(this.schemaContexts.getSchemas());
        schemas.put(event.getSchemaName(), this.createAddedSchemaContext(event));
        this.schemaContexts = new StandardSchemaContexts(schemas, this.schemaContexts.getExecutorKernel(), this.schemaContexts.getAuthentication(), this.schemaContexts.getProps(), this.schemaContexts.getDatabaseType());
        this.governanceFacade.getConfigCenter().persistMetaData(event.getSchemaName(), ((ShardingSphereSchema)this.schemaContexts.getSchemas().get(event.getSchemaName())).getMetaData().getSchemaMetaData());
        GovernanceEventBus.getInstance().post((Object)new DataSourceChangeCompletedEvent(event.getSchemaName(), this.schemaContexts.getDatabaseType(), ((ShardingSphereSchema)schemas.get(event.getSchemaName())).getDataSources()));
    }

    @Subscribe
    public synchronized void renew(SchemaDeletedEvent event) {
        HashMap schemas = new HashMap(this.schemaContexts.getSchemas());
        schemas.remove(event.getSchemaName());
        this.schemaContexts = new StandardSchemaContexts(schemas, this.schemaContexts.getExecutorKernel(), this.schemaContexts.getAuthentication(), this.schemaContexts.getProps(), this.schemaContexts.getDatabaseType());
        this.governanceFacade.getConfigCenter().deleteSchema(event.getSchemaName());
    }

    @Subscribe
    public synchronized void renew(PropertiesChangedEvent event) {
        ConfigurationProperties props = new ConfigurationProperties(event.getProps());
        this.schemaContexts = new StandardSchemaContexts(this.getChangedSchemas(), this.schemaContexts.getExecutorKernel(), this.schemaContexts.getAuthentication(), props, this.schemaContexts.getDatabaseType());
    }

    @Subscribe
    public synchronized void renew(AuthenticationChangedEvent event) {
        this.schemaContexts = new StandardSchemaContexts(this.schemaContexts.getSchemas(), this.schemaContexts.getExecutorKernel(), event.getAuthentication(), this.schemaContexts.getProps(), this.schemaContexts.getDatabaseType());
    }

    @Subscribe
    public synchronized void renew(MetaDataChangedEvent event) {
        HashMap<String, ShardingSphereSchema> newSchemas = new HashMap<String, ShardingSphereSchema>(this.schemaContexts.getSchemas().size(), 1.0f);
        for (Map.Entry entry : this.schemaContexts.getSchemas().entrySet()) {
            String schemaName = (String)entry.getKey();
            ShardingSphereSchema oldSchema = (ShardingSphereSchema)entry.getValue();
            ShardingSphereSchema newSchema = event.getSchemaName().equals(schemaName) ? this.getChangedShardingSphereSchema(oldSchema, event.getLogicSchemaMetaData(), schemaName) : oldSchema;
            newSchemas.put(schemaName, newSchema);
        }
        this.schemaContexts = new StandardSchemaContexts(newSchemas, this.schemaContexts.getExecutorKernel(), this.schemaContexts.getAuthentication(), this.schemaContexts.getProps(), this.schemaContexts.getDatabaseType());
    }

    @Subscribe
    public synchronized void renew(RuleConfigurationsChangedEvent event) throws SQLException {
        HashMap<String, ShardingSphereSchema> newSchemaContexts = new HashMap<String, ShardingSphereSchema>(this.schemaContexts.getSchemas());
        String schemaName = event.getSchemaName();
        newSchemaContexts.remove(schemaName);
        newSchemaContexts.put(schemaName, this.getChangedSchema((ShardingSphereSchema)this.schemaContexts.getSchemas().get(schemaName), event.getRuleConfigurations()));
        this.schemaContexts = new StandardSchemaContexts(newSchemaContexts, this.schemaContexts.getExecutorKernel(), this.schemaContexts.getAuthentication(), this.schemaContexts.getProps(), this.schemaContexts.getDatabaseType());
        this.governanceFacade.getConfigCenter().persistMetaData(schemaName, ((ShardingSphereSchema)newSchemaContexts.get(schemaName)).getMetaData().getSchemaMetaData());
    }

    @Subscribe
    public synchronized void renew(DataSourceChangedEvent event) throws SQLException {
        String schemaName = event.getSchemaName();
        HashMap<String, ShardingSphereSchema> newSchemas = new HashMap<String, ShardingSphereSchema>(this.schemaContexts.getSchemas());
        newSchemas.remove(schemaName);
        newSchemas.put(schemaName, this.getChangedSchema((ShardingSphereSchema)this.schemaContexts.getSchemas().get(schemaName), event.getDataSourceConfigurations()));
        this.schemaContexts = new StandardSchemaContexts(newSchemas, this.schemaContexts.getExecutorKernel(), this.schemaContexts.getAuthentication(), this.schemaContexts.getProps(), this.schemaContexts.getDatabaseType());
        GovernanceEventBus.getInstance().post((Object)new DataSourceChangeCompletedEvent(event.getSchemaName(), this.schemaContexts.getDatabaseType(), ((ShardingSphereSchema)newSchemas.get(event.getSchemaName())).getDataSources()));
    }

    @Subscribe
    public synchronized void renew(DisabledStateChangedEvent event) {
        GovernanceSchema governanceSchema = event.getGovernanceSchema();
        Collection rules = ((ShardingSphereSchema)this.schemaContexts.getSchemas().get(governanceSchema.getSchemaName())).getRules();
        for (ShardingSphereRule each : rules) {
            if (!(each instanceof StatusContainedRule)) continue;
            ((StatusContainedRule)each).updateRuleStatus((RuleChangedEvent)new DataSourceNameDisabledEvent(governanceSchema.getDataSourceName(), event.isDisabled()));
        }
    }

    @Subscribe
    public synchronized void renew(CircuitStateChangedEvent event) {
        this.schemaContexts = new StandardSchemaContexts(this.schemaContexts.getSchemas(), this.schemaContexts.getExecutorKernel(), this.schemaContexts.getAuthentication(), this.schemaContexts.getProps(), this.schemaContexts.getDatabaseType(), event.isCircuitBreak());
    }

    private ShardingSphereSchema createAddedSchemaContext(SchemaAddedEvent event) throws SQLException {
        String schemaName = event.getSchemaName();
        Map<String, Map<String, DataSource>> dataSourcesMap = this.createDataSourcesMap(Collections.singletonMap(schemaName, this.governanceFacade.getConfigCenter().loadDataSourceConfigurations(schemaName)));
        DatabaseType databaseType = this.getDatabaseType(dataSourcesMap);
        SchemaContextsBuilder schemaContextsBuilder = new SchemaContextsBuilder(databaseType, dataSourcesMap, Collections.singletonMap(schemaName, this.governanceFacade.getConfigCenter().loadRuleConfigurations(schemaName)), this.schemaContexts.getAuthentication(), this.schemaContexts.getProps().getProps());
        return (ShardingSphereSchema)schemaContextsBuilder.build().getSchemas().get(schemaName);
    }

    private Map<String, ShardingSphereSchema> getChangedSchemas() {
        HashMap<String, ShardingSphereSchema> result = new HashMap<String, ShardingSphereSchema>(this.schemaContexts.getSchemas().size());
        for (Map.Entry entry : this.schemaContexts.getSchemas().entrySet()) {
            result.put((String)entry.getKey(), (ShardingSphereSchema)entry.getValue());
        }
        return result;
    }

    private ShardingSphereSchema getChangedShardingSphereSchema(ShardingSphereSchema oldSchema, LogicSchemaMetaData newLogicSchemaMetaData, String schemaName) {
        ShardingSphereMetaData metaData = new ShardingSphereMetaData(oldSchema.getMetaData().getDataSourcesMetaData(), newLogicSchemaMetaData, oldSchema.getMetaData().getTableAddressingMetaData(), oldSchema.getMetaData().getCachedDatabaseMetaData());
        return new ShardingSphereSchema(schemaName, oldSchema.getConfigurations(), oldSchema.getRules(), oldSchema.getDataSources(), metaData);
    }

    private ShardingSphereSchema getChangedSchema(ShardingSphereSchema oldSchema, Collection<RuleConfiguration> ruleConfigs) throws SQLException {
        SchemaContextsBuilder builder = new SchemaContextsBuilder(this.schemaContexts.getDatabaseType(), Collections.singletonMap(oldSchema.getName(), oldSchema.getDataSources()), Collections.singletonMap(oldSchema.getName(), ruleConfigs), this.schemaContexts.getAuthentication(), this.schemaContexts.getProps().getProps());
        return (ShardingSphereSchema)builder.build().getSchemas().values().iterator().next();
    }

    private ShardingSphereSchema getChangedSchema(ShardingSphereSchema oldSchema, Map<String, DataSourceConfiguration> newDataSourceConfigs) throws SQLException {
        Collection<String> deletedDataSources = this.getDeletedDataSources(oldSchema, newDataSourceConfigs);
        Map<String, DataSource> modifiedDataSources = this.getModifiedDataSources(oldSchema, newDataSourceConfigs);
        oldSchema.closeDataSources(deletedDataSources);
        oldSchema.closeDataSources(modifiedDataSources.keySet());
        Map<String, Map<String, DataSource>> dataSourcesMap = Collections.singletonMap(oldSchema.getName(), this.getNewDataSources(oldSchema.getDataSources(), this.getAddedDataSources(oldSchema, newDataSourceConfigs), modifiedDataSources, deletedDataSources));
        return (ShardingSphereSchema)new SchemaContextsBuilder(this.schemaContexts.getDatabaseType(), dataSourcesMap, Collections.singletonMap(oldSchema.getName(), oldSchema.getConfigurations()), this.schemaContexts.getAuthentication(), this.schemaContexts.getProps().getProps()).build().getSchemas().get(oldSchema.getName());
    }

    private Map<String, DataSource> getNewDataSources(Map<String, DataSource> oldDataSources, Map<String, DataSource> addedDataSources, Map<String, DataSource> modifiedDataSources, Collection<String> deletedDataSources) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>(oldDataSources);
        result.keySet().removeAll(deletedDataSources);
        result.keySet().removeAll(modifiedDataSources.keySet());
        result.putAll(modifiedDataSources);
        result.putAll(addedDataSources);
        return result;
    }

    private Collection<String> getDeletedDataSources(ShardingSphereSchema oldSchema, Map<String, DataSourceConfiguration> newDataSourceConfigs) {
        LinkedList<String> result = new LinkedList<String>(oldSchema.getDataSources().keySet());
        result.removeAll(newDataSourceConfigs.keySet());
        return result;
    }

    private Map<String, DataSource> getAddedDataSources(ShardingSphereSchema oldSchema, Map<String, DataSourceConfiguration> newDataSourceConfigs) {
        return DataSourceConverter.getDataSourceMap((Map)Maps.filterKeys(newDataSourceConfigs, each -> !oldSchema.getDataSources().containsKey(each)));
    }

    private Map<String, DataSource> getModifiedDataSources(ShardingSphereSchema oldSchema, Map<String, DataSourceConfiguration> newDataSourceConfigs) {
        Map modifiedDataSourceConfigs = newDataSourceConfigs.entrySet().stream().filter(entry -> this.isModifiedDataSource(oldSchema.getDataSources(), (String)entry.getKey(), (DataSourceConfiguration)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        return DataSourceConverter.getDataSourceMap((Map)modifiedDataSourceConfigs);
    }

    private boolean isModifiedDataSource(Map<String, DataSource> oldDataSources, String newDataSourceName, DataSourceConfiguration newDataSourceConfig) {
        DataSourceConfiguration dataSourceConfig = (DataSourceConfiguration)DataSourceConverter.getDataSourceConfigurationMap(oldDataSources).get(newDataSourceName);
        return null != dataSourceConfig && !newDataSourceConfig.equals((Object)dataSourceConfig);
    }

    private Map<String, Map<String, DataSource>> createDataSourcesMap(Map<String, Map<String, DataSourceConfiguration>> dataSourcesConfigs) {
        LinkedHashMap<String, Map<String, DataSource>> result = new LinkedHashMap<String, Map<String, DataSource>>(dataSourcesConfigs.size(), 1.0f);
        for (Map.Entry<String, Map<String, DataSourceConfiguration>> entry : dataSourcesConfigs.entrySet()) {
            result.put(entry.getKey(), DataSourceConverter.getDataSourceMap(entry.getValue()));
        }
        return result;
    }
}

