/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dialect;

import java.sql.SQLException;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.dialect.exception.SQLDialectException;
import org.apache.shardingsphere.dialect.exception.protocol.DatabaseProtocolException;
import org.apache.shardingsphere.dialect.mapper.SQLDialectExceptionMapper;
import org.apache.shardingsphere.infra.util.exception.external.sql.ShardingSphereSQLException;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.DatabaseProtocolSQLException;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnknownSQLException;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPIRegistry;

public final class SQLExceptionTransformEngine {
    public static SQLException toSQLException(Exception cause, String databaseType) {
        if (cause instanceof SQLException) {
            return (SQLException)cause;
        }
        if (cause instanceof ShardingSphereSQLException) {
            return ((ShardingSphereSQLException)cause).toSQLException();
        }
        if (cause instanceof SQLDialectException) {
            if (cause instanceof DatabaseProtocolException) {
                return new DatabaseProtocolSQLException(cause.getMessage()).toSQLException();
            }
            Optional dialectExceptionMapper = TypedSPIRegistry.findRegisteredService(SQLDialectExceptionMapper.class, (String)databaseType);
            if (dialectExceptionMapper.isPresent()) {
                return ((SQLDialectExceptionMapper)dialectExceptionMapper.get()).convert((SQLDialectException)((Object)cause));
            }
        }
        return new UnknownSQLException(cause).toSQLException();
    }

    @Generated
    private SQLExceptionTransformEngine() {
    }
}

