/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.opengauss.packet.command.generic;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierTag;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLMessagePacketType;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class OpenGaussErrorResponsePacket
implements PostgreSQLIdentifierPacket {
    public static final char FIELD_TYPE_SEVERITY = 'S';
    public static final char FIELD_TYPE_CODE = 'C';
    public static final char FIELD_TYPE_MESSAGE = 'M';
    public static final char FIELD_TYPE_DETAIL = 'D';
    public static final char FIELD_TYPE_HINT = 'H';
    public static final char FIELD_TYPE_POSITION = 'P';
    public static final char FIELD_TYPE_INTERNAL_POSITION = 'p';
    public static final char FIELD_TYPE_INTERNAL_QUERY = 'q';
    public static final char FIELD_TYPE_WHERE = 'W';
    public static final char FIELD_TYPE_FILE = 'F';
    public static final char FIELD_TYPE_LINE = 'L';
    public static final char FIELD_TYPE_ROUTINE = 'R';
    public static final char FIELD_TYPE_ERRORCODE = 'c';
    public static final char FIELD_TYPE_SOCKET_ADDRESS = 'a';
    private final Map<Character, String> fields;

    public OpenGaussErrorResponsePacket(Map<Character, String> serverErrorMessageMap) {
        this.fields = new LinkedHashMap<Character, String>(serverErrorMessageMap.size(), 1.0f);
        this.fields.putAll(serverErrorMessageMap);
        this.fillRequiredFieldsIfNecessary();
    }

    public OpenGaussErrorResponsePacket(String severityLevel, String sqlState, String message) {
        this.fields = new LinkedHashMap<Character, String>(4, 1.0f);
        this.fields.put(Character.valueOf('S'), severityLevel);
        this.fields.put(Character.valueOf('C'), sqlState);
        this.fields.put(Character.valueOf('M'), message);
        this.fillRequiredFieldsIfNecessary();
    }

    private void fillRequiredFieldsIfNecessary() {
        this.fields.putIfAbsent(Character.valueOf('c'), "0");
    }

    public String toServerErrorMessage() {
        return this.fields.entrySet().stream().map(entry -> entry.getKey() + (String)entry.getValue()).collect(Collectors.joining("\u0000"));
    }

    public void write(PostgreSQLPacketPayload payload) {
        for (Map.Entry<Character, String> each : this.fields.entrySet()) {
            payload.writeInt1((int)each.getKey().charValue());
            payload.writeStringNul(each.getValue());
        }
        payload.writeInt1(0);
    }

    public PostgreSQLIdentifierTag getIdentifier() {
        return PostgreSQLMessagePacketType.ERROR_RESPONSE;
    }
}

