/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.opengauss.packet.command.query.extended.bind;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.binary.BinaryColumnType;
import org.apache.shardingsphere.db.protocol.opengauss.packet.command.OpenGaussCommandPacket;
import org.apache.shardingsphere.db.protocol.opengauss.packet.command.OpenGaussCommandPacketType;
import org.apache.shardingsphere.db.protocol.opengauss.packet.identifier.OpenGaussIdentifierTag;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLValueFormat;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLBinaryProtocolValueFactory;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLTextTimestampUtils;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class OpenGaussComBatchBindPacket
extends OpenGaussCommandPacket {
    private final PostgreSQLPacketPayload payload;
    private final int batchNum;
    private final String statementId;
    private final List<Integer> parameterFormats;
    private final List<PostgreSQLValueFormat> resultFormats;
    private final int eachGroupParametersCount;

    public OpenGaussComBatchBindPacket(PostgreSQLPacketPayload payload) {
        this.payload = payload;
        payload.readInt4();
        this.batchNum = payload.readInt4();
        payload.readStringNul();
        this.statementId = payload.readStringNul();
        int parameterFormatCount = payload.readInt2();
        this.parameterFormats = new ArrayList<Integer>(parameterFormatCount);
        for (int i = 0; i < parameterFormatCount; ++i) {
            this.parameterFormats.add(payload.readInt2());
        }
        int resultFormatsLength = payload.readInt2();
        this.resultFormats = new ArrayList<PostgreSQLValueFormat>(resultFormatsLength);
        for (int i = 0; i < resultFormatsLength; ++i) {
            this.resultFormats.add(PostgreSQLValueFormat.valueOf((int)payload.readInt2()));
        }
        this.eachGroupParametersCount = payload.readInt2();
    }

    public List<List<Object>> readParameterSets(List<PostgreSQLColumnType> parameterTypes) {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>(this.batchNum);
        for (int i = 0; i < this.batchNum; ++i) {
            result.add(this.readOneGroupOfParameters(parameterTypes));
        }
        this.payload.skipReserved(this.payload.getByteBuf().readableBytes());
        return result;
    }

    private List<Object> readOneGroupOfParameters(List<PostgreSQLColumnType> parameterTypes) {
        ArrayList<Object> result = new ArrayList<Object>(this.eachGroupParametersCount);
        for (int parameterIndex = 0; parameterIndex < this.eachGroupParametersCount; ++parameterIndex) {
            int parameterValueLength = this.payload.readInt4();
            if (-1 == parameterValueLength) {
                result.add(null);
                continue;
            }
            Object parameterValue = this.isTextParameterValue(this.parameterFormats, parameterIndex) ? this.getTextParameters(this.payload, parameterValueLength, parameterTypes.get(parameterIndex)) : this.getBinaryParameters(this.payload, parameterValueLength, parameterTypes.get(parameterIndex));
            result.add(parameterValue);
        }
        return result;
    }

    private boolean isTextParameterValue(List<Integer> parameterFormats, int parameterIndex) {
        return parameterFormats.isEmpty() || 0 == parameterFormats.get(parameterIndex % parameterFormats.size());
    }

    private Object getTextParameters(PostgreSQLPacketPayload payload, int parameterValueLength, PostgreSQLColumnType parameterType) {
        String value = payload.getByteBuf().readCharSequence(parameterValueLength, payload.getCharset()).toString();
        return this.getTextParameters(value, parameterType);
    }

    private Object getTextParameters(String textValue, PostgreSQLColumnType columnType) {
        switch (columnType) {
            case POSTGRESQL_TYPE_BOOL: {
                return Boolean.valueOf(textValue);
            }
            case POSTGRESQL_TYPE_INT2: 
            case POSTGRESQL_TYPE_INT4: {
                return Integer.parseInt(textValue);
            }
            case POSTGRESQL_TYPE_INT8: {
                return Long.parseLong(textValue);
            }
            case POSTGRESQL_TYPE_FLOAT4: {
                return Float.valueOf(Float.parseFloat(textValue));
            }
            case POSTGRESQL_TYPE_FLOAT8: {
                return Double.parseDouble(textValue);
            }
            case POSTGRESQL_TYPE_NUMERIC: {
                try {
                    return Integer.parseInt(textValue);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return Long.parseLong(textValue);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        return new BigDecimal(textValue);
                    }
                }
            }
            case POSTGRESQL_TYPE_DATE: {
                return Date.valueOf(textValue);
            }
            case POSTGRESQL_TYPE_TIME: {
                return Time.valueOf(textValue);
            }
            case POSTGRESQL_TYPE_TIMESTAMP: 
            case POSTGRESQL_TYPE_TIMESTAMPTZ: {
                return PostgreSQLTextTimestampUtils.parse((String)textValue);
            }
        }
        return textValue;
    }

    private Object getBinaryParameters(PostgreSQLPacketPayload payload, int parameterValueLength, PostgreSQLColumnType columnType) {
        PostgreSQLBinaryProtocolValue binaryProtocolValue = PostgreSQLBinaryProtocolValueFactory.getBinaryProtocolValue((BinaryColumnType)columnType);
        return binaryProtocolValue.read(payload, parameterValueLength);
    }

    public void write(PostgreSQLPacketPayload payload) {
    }

    public OpenGaussIdentifierTag getIdentifier() {
        return OpenGaussCommandPacketType.BATCH_BIND_COMMAND;
    }

    @Generated
    public PostgreSQLPacketPayload getPayload() {
        return this.payload;
    }

    @Generated
    public int getBatchNum() {
        return this.batchNum;
    }

    @Generated
    public String getStatementId() {
        return this.statementId;
    }

    @Generated
    public List<Integer> getParameterFormats() {
        return this.parameterFormats;
    }

    @Generated
    public List<PostgreSQLValueFormat> getResultFormats() {
        return this.resultFormats;
    }

    @Generated
    public int getEachGroupParametersCount() {
        return this.eachGroupParametersCount;
    }

    @Generated
    public String toString() {
        return "OpenGaussComBatchBindPacket(payload=" + this.getPayload() + ", batchNum=" + this.getBatchNum() + ", statementId=" + this.getStatementId() + ", parameterFormats=" + this.getParameterFormats() + ", resultFormats=" + this.getResultFormats() + ", eachGroupParametersCount=" + this.getEachGroupParametersCount() + ")";
    }
}

