/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.opengauss.packet.command.query.binary.bind;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.binary.BinaryColumnType;
import org.apache.shardingsphere.db.protocol.opengauss.packet.command.OpenGaussCommandPacket;
import org.apache.shardingsphere.db.protocol.opengauss.packet.command.OpenGaussCommandPacketType;
import org.apache.shardingsphere.db.protocol.opengauss.packet.identifier.OpenGaussIdentifierTag;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLValueFormat;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.PostgreSQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.PostgreSQLBinaryStatement;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.PostgreSQLBinaryStatementRegistry;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.bind.PostgreSQLTypeUnspecifiedSQLParameter;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.bind.protocol.PostgreSQLBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.bind.protocol.PostgreSQLBinaryProtocolValueFactory;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class OpenGaussComBatchBindPacket
extends OpenGaussCommandPacket {
    private final PostgreSQLPacketPayload payload;
    private final String statementId;
    private final String sql;
    private final List<Integer> parameterFormats;
    private final List<PostgreSQLValueFormat> resultFormats;
    private final PostgreSQLBinaryStatement binaryStatement;
    private final int eachGroupParametersCount;

    public OpenGaussComBatchBindPacket(PostgreSQLPacketPayload payload, int connectionId) {
        this.payload = payload;
        payload.readInt4();
        payload.readInt4();
        payload.readStringNul();
        this.statementId = payload.readStringNul();
        int parameterFormatCount = payload.readInt2();
        this.parameterFormats = new ArrayList<Integer>(parameterFormatCount);
        for (int i = 0; i < parameterFormatCount; ++i) {
            this.parameterFormats.add(payload.readInt2());
        }
        int resultFormatsLength = payload.readInt2();
        this.resultFormats = new ArrayList<PostgreSQLValueFormat>(resultFormatsLength);
        for (int i = 0; i < resultFormatsLength; ++i) {
            this.resultFormats.add(PostgreSQLValueFormat.valueOf((int)payload.readInt2()));
        }
        this.binaryStatement = PostgreSQLBinaryStatementRegistry.getInstance().get(connectionId, this.statementId);
        this.sql = null == this.binaryStatement ? null : this.binaryStatement.getSql();
        this.eachGroupParametersCount = payload.readInt2();
    }

    public boolean hasNextParameters() {
        if (this.payload.getByteBuf().readableBytes() < 1) {
            return false;
        }
        this.payload.getByteBuf().markReaderIndex();
        int c = this.payload.readInt1();
        this.payload.getByteBuf().resetReaderIndex();
        return 69 != c;
    }

    public List<Object> readOneGroupOfParameters() {
        List columnTypes = this.binaryStatement.getColumnTypes();
        ArrayList<Object> result = new ArrayList<Object>(this.eachGroupParametersCount);
        for (int parameterIndex = 0; parameterIndex < this.eachGroupParametersCount; ++parameterIndex) {
            int parameterValueLength = this.payload.readInt4();
            if (-1 == parameterValueLength) {
                result.add(null);
                continue;
            }
            Object parameterValue = this.isTextParameterValue(this.parameterFormats, parameterIndex) ? this.getTextParameters(this.payload, parameterValueLength, (PostgreSQLBinaryColumnType)columnTypes.get(parameterIndex)) : this.getBinaryParameters(this.payload, parameterValueLength, (PostgreSQLBinaryColumnType)columnTypes.get(parameterIndex));
            result.add(parameterValue);
        }
        return result;
    }

    private boolean isTextParameterValue(List<Integer> parameterFormats, int parameterIndex) {
        return parameterFormats.isEmpty() || 0 == parameterFormats.get(parameterIndex % parameterFormats.size());
    }

    private Object getTextParameters(PostgreSQLPacketPayload payload, int parameterValueLength, PostgreSQLBinaryColumnType columnType) {
        byte[] bytes = new byte[parameterValueLength];
        payload.getByteBuf().readBytes(bytes);
        return this.getTextParameters(new String(bytes), columnType);
    }

    private Object getTextParameters(String textValue, PostgreSQLBinaryColumnType columnType) {
        switch (columnType) {
            case POSTGRESQL_TYPE_UNSPECIFIED: {
                return new PostgreSQLTypeUnspecifiedSQLParameter(textValue);
            }
            case POSTGRESQL_TYPE_BOOL: {
                return Boolean.valueOf(textValue);
            }
            case POSTGRESQL_TYPE_INT2: 
            case POSTGRESQL_TYPE_INT4: {
                return Integer.parseInt(textValue);
            }
            case POSTGRESQL_TYPE_INT8: {
                return Long.parseLong(textValue);
            }
            case POSTGRESQL_TYPE_FLOAT4: {
                return Float.valueOf(Float.parseFloat(textValue));
            }
            case POSTGRESQL_TYPE_FLOAT8: {
                return Double.parseDouble(textValue);
            }
            case POSTGRESQL_TYPE_NUMERIC: {
                try {
                    return Integer.parseInt(textValue);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return Long.parseLong(textValue);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        return new BigDecimal(textValue);
                    }
                }
            }
            case POSTGRESQL_TYPE_DATE: {
                return Date.valueOf(textValue);
            }
            case POSTGRESQL_TYPE_TIME: {
                return Time.valueOf(textValue);
            }
            case POSTGRESQL_TYPE_TIMESTAMP: 
            case POSTGRESQL_TYPE_TIMESTAMPTZ: {
                return Timestamp.valueOf(textValue);
            }
        }
        return textValue;
    }

    private Object getBinaryParameters(PostgreSQLPacketPayload payload, int parameterValueLength, PostgreSQLBinaryColumnType columnType) {
        PostgreSQLBinaryProtocolValue binaryProtocolValue = PostgreSQLBinaryProtocolValueFactory.getBinaryProtocolValue((BinaryColumnType)columnType);
        return binaryProtocolValue.read(payload, parameterValueLength);
    }

    public void write(PostgreSQLPacketPayload payload) {
    }

    public OpenGaussIdentifierTag getIdentifier() {
        return OpenGaussCommandPacketType.BATCH_BIND_COMMAND;
    }

    @Generated
    public PostgreSQLPacketPayload getPayload() {
        return this.payload;
    }

    @Generated
    public String getStatementId() {
        return this.statementId;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public List<Integer> getParameterFormats() {
        return this.parameterFormats;
    }

    @Generated
    public List<PostgreSQLValueFormat> getResultFormats() {
        return this.resultFormats;
    }

    @Generated
    public PostgreSQLBinaryStatement getBinaryStatement() {
        return this.binaryStatement;
    }

    @Generated
    public int getEachGroupParametersCount() {
        return this.eachGroupParametersCount;
    }

    @Generated
    public String toString() {
        return "OpenGaussComBatchBindPacket(payload=" + this.getPayload() + ", statementId=" + this.getStatementId() + ", sql=" + this.getSql() + ", parameterFormats=" + this.getParameterFormats() + ", resultFormats=" + this.getResultFormats() + ", binaryStatement=" + this.getBinaryStatement() + ", eachGroupParametersCount=" + this.getEachGroupParametersCount() + ")";
    }
}

