/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.handshake;

import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLAuthenticationMethod;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCapabilityFlag;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLHandshakeResponse41Packet
implements MySQLPacket {
    private final int sequenceId;
    private final int maxPacketSize;
    private final int characterSet;
    private final String username;
    private byte[] authResponse;
    private int capabilityFlags;
    private String database;
    private String authPluginName;

    public MySQLHandshakeResponse41Packet(MySQLPacketPayload payload) {
        this.sequenceId = payload.readInt1();
        this.capabilityFlags = payload.readInt4();
        this.maxPacketSize = payload.readInt4();
        this.characterSet = payload.readInt1();
        payload.skipReserved(23);
        this.username = payload.readStringNul();
        this.authResponse = this.readAuthResponse(payload);
        this.database = this.readDatabase(payload);
        this.authPluginName = this.readAuthPluginName(payload);
    }

    private byte[] readAuthResponse(MySQLPacketPayload payload) {
        if (0 != (this.capabilityFlags & MySQLCapabilityFlag.CLIENT_PLUGIN_AUTH_LENENC_CLIENT_DATA.getValue())) {
            return payload.readStringLenencByBytes();
        }
        if (0 != (this.capabilityFlags & MySQLCapabilityFlag.CLIENT_SECURE_CONNECTION.getValue())) {
            int length = payload.readInt1();
            return payload.readStringFixByBytes(length);
        }
        return payload.readStringNulByBytes();
    }

    private String readDatabase(MySQLPacketPayload payload) {
        return 0 != (this.capabilityFlags & MySQLCapabilityFlag.CLIENT_CONNECT_WITH_DB.getValue()) ? payload.readStringNul() : null;
    }

    private String readAuthPluginName(MySQLPacketPayload payload) {
        return 0 != (this.capabilityFlags & MySQLCapabilityFlag.CLIENT_PLUGIN_AUTH.getValue()) ? payload.readStringNul() : null;
    }

    public void setDatabase(String database) {
        this.database = database;
        this.capabilityFlags |= MySQLCapabilityFlag.CLIENT_CONNECT_WITH_DB.getValue();
    }

    public void setAuthPluginName(MySQLAuthenticationMethod mysqlAuthenticationMethod) {
        this.authPluginName = mysqlAuthenticationMethod.getMethodName();
        this.capabilityFlags |= MySQLCapabilityFlag.CLIENT_PLUGIN_AUTH.getValue();
    }

    public void write(MySQLPacketPayload payload) {
        payload.writeInt4(this.capabilityFlags);
        payload.writeInt4(this.maxPacketSize);
        payload.writeInt1(this.characterSet);
        payload.writeReserved(23);
        payload.writeStringNul(this.username);
        this.writeAuthResponse(payload);
        this.writeDatabase(payload);
        this.writeAuthPluginName(payload);
    }

    private void writeAuthResponse(MySQLPacketPayload payload) {
        if (0 != (this.capabilityFlags & MySQLCapabilityFlag.CLIENT_PLUGIN_AUTH_LENENC_CLIENT_DATA.getValue())) {
            payload.writeStringLenenc(new String(this.authResponse));
        } else if (0 != (this.capabilityFlags & MySQLCapabilityFlag.CLIENT_SECURE_CONNECTION.getValue())) {
            payload.writeInt1(this.authResponse.length);
            payload.writeBytes(this.authResponse);
        } else {
            payload.writeStringNul(new String(this.authResponse));
        }
    }

    private void writeDatabase(MySQLPacketPayload payload) {
        if (0 != (this.capabilityFlags & MySQLCapabilityFlag.CLIENT_CONNECT_WITH_DB.getValue())) {
            payload.writeStringNul(this.database);
        }
    }

    private void writeAuthPluginName(MySQLPacketPayload payload) {
        if (0 != (this.capabilityFlags & MySQLCapabilityFlag.CLIENT_PLUGIN_AUTH.getValue())) {
            payload.writeStringNul(this.authPluginName);
        }
    }

    @Generated
    public MySQLHandshakeResponse41Packet(int sequenceId, int maxPacketSize, int characterSet, String username) {
        this.sequenceId = sequenceId;
        this.maxPacketSize = maxPacketSize;
        this.characterSet = characterSet;
        this.username = username;
    }

    @Override
    @Generated
    public int getSequenceId() {
        return this.sequenceId;
    }

    @Generated
    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    @Generated
    public int getCharacterSet() {
        return this.characterSet;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public byte[] getAuthResponse() {
        return this.authResponse;
    }

    @Generated
    public int getCapabilityFlags() {
        return this.capabilityFlags;
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public String getAuthPluginName() {
        return this.authPluginName;
    }

    @Generated
    public void setAuthResponse(byte[] authResponse) {
        this.authResponse = authResponse;
    }

    @Generated
    public void setCapabilityFlags(int capabilityFlags) {
        this.capabilityFlags = capabilityFlags;
    }
}

