/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.handshake;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLAuthenticationMethod;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCapabilityFlag;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLServerInfo;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLStatusFlag;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLAuthPluginData;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLHandshakePacket
implements MySQLPacket {
    private final int protocolVersion = 10;
    private final String serverVersion;
    private final int connectionId;
    private final int capabilityFlagsLower;
    private final int characterSet;
    private final MySQLStatusFlag statusFlag;
    private final MySQLAuthPluginData authPluginData;
    private int capabilityFlagsUpper;
    private String authPluginName;

    public MySQLHandshakePacket(int connectionId, MySQLAuthPluginData authPluginData) {
        this.serverVersion = MySQLServerInfo.getServerVersion();
        this.connectionId = connectionId;
        this.capabilityFlagsLower = MySQLCapabilityFlag.calculateHandshakeCapabilityFlagsLower();
        this.characterSet = MySQLServerInfo.DEFAULT_CHARSET.getId();
        this.statusFlag = MySQLStatusFlag.SERVER_STATUS_AUTOCOMMIT;
        this.capabilityFlagsUpper = MySQLCapabilityFlag.calculateHandshakeCapabilityFlagsUpper();
        this.authPluginData = authPluginData;
        this.authPluginName = MySQLAuthenticationMethod.SECURE_PASSWORD_AUTHENTICATION.getMethodName();
    }

    public MySQLHandshakePacket(MySQLPacketPayload payload) {
        Preconditions.checkArgument((0 == payload.readInt1() ? 1 : 0) != 0, (Object)"Sequence ID of MySQL handshake packet must be `0`.");
        Preconditions.checkArgument((10 == payload.readInt1() ? 1 : 0) != 0);
        this.serverVersion = payload.readStringNul();
        this.connectionId = payload.readInt4();
        byte[] authPluginDataPart1 = payload.readStringNulByBytes();
        this.capabilityFlagsLower = payload.readInt2();
        this.characterSet = payload.readInt1();
        this.statusFlag = MySQLStatusFlag.valueOf(payload.readInt2());
        this.capabilityFlagsUpper = payload.readInt2();
        payload.readInt1();
        payload.skipReserved(10);
        this.authPluginData = new MySQLAuthPluginData(authPluginDataPart1, this.readAuthPluginDataPart2(payload));
        this.authPluginName = this.readAuthPluginName(payload);
    }

    private byte[] readAuthPluginDataPart2(MySQLPacketPayload payload) {
        return this.isClientSecureConnection() ? payload.readStringNulByBytes() : new byte[]{};
    }

    private String readAuthPluginName(MySQLPacketPayload payload) {
        return this.isClientPluginAuth() ? payload.readStringNul() : null;
    }

    public void setAuthPluginName(MySQLAuthenticationMethod mysqlAuthenticationMethod) {
        this.authPluginName = mysqlAuthenticationMethod.getMethodName();
        this.capabilityFlagsUpper |= MySQLCapabilityFlag.CLIENT_PLUGIN_AUTH.getValue() >> 16;
    }

    public void write(MySQLPacketPayload payload) {
        payload.writeInt1(10);
        payload.writeStringNul(this.serverVersion);
        payload.writeInt4(this.connectionId);
        payload.writeStringNul(new String(this.authPluginData.getAuthPluginDataPart1()));
        payload.writeInt2(this.capabilityFlagsLower);
        payload.writeInt1(this.characterSet);
        payload.writeInt2(this.statusFlag.getValue());
        payload.writeInt2(this.capabilityFlagsUpper);
        payload.writeInt1(this.isClientPluginAuth() ? this.authPluginData.getAuthenticationPluginData().length + 1 : 0);
        payload.writeReserved(10);
        this.writeAuthPluginDataPart2(payload);
        this.writeAuthPluginName(payload);
    }

    private void writeAuthPluginDataPart2(MySQLPacketPayload payload) {
        if (this.isClientSecureConnection()) {
            payload.writeStringNul(new String(this.authPluginData.getAuthPluginDataPart2()));
        }
    }

    private void writeAuthPluginName(MySQLPacketPayload payload) {
        if (this.isClientPluginAuth()) {
            payload.writeStringNul(this.authPluginName);
        }
    }

    private boolean isClientSecureConnection() {
        return 0 != (this.capabilityFlagsLower & MySQLCapabilityFlag.CLIENT_SECURE_CONNECTION.getValue() & 0xFFFF);
    }

    private boolean isClientPluginAuth() {
        return 0 != (this.capabilityFlagsUpper & MySQLCapabilityFlag.CLIENT_PLUGIN_AUTH.getValue() >> 16);
    }

    @Override
    public int getSequenceId() {
        return 0;
    }

    @Generated
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @Generated
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Generated
    public int getConnectionId() {
        return this.connectionId;
    }

    @Generated
    public int getCapabilityFlagsLower() {
        return this.capabilityFlagsLower;
    }

    @Generated
    public int getCharacterSet() {
        return this.characterSet;
    }

    @Generated
    public MySQLStatusFlag getStatusFlag() {
        return this.statusFlag;
    }

    @Generated
    public MySQLAuthPluginData getAuthPluginData() {
        return this.authPluginData;
    }

    @Generated
    public int getCapabilityFlagsUpper() {
        return this.capabilityFlagsUpper;
    }

    @Generated
    public String getAuthPluginName() {
        return this.authPluginName;
    }
}

