/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.generic;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLStatusFlag;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLOKPacket
implements MySQLPacket {
    public static final int HEADER = 0;
    private static final int DEFAULT_STATUS_FLAG = MySQLStatusFlag.SERVER_STATUS_AUTOCOMMIT.getValue();
    private final int sequenceId;
    private final long affectedRows;
    private final long lastInsertId;
    private final int statusFlag;
    private final int warnings;
    private final String info;

    public MySQLOKPacket(int sequenceId) {
        this(sequenceId, 0L, 0L, DEFAULT_STATUS_FLAG, 0, "");
    }

    public MySQLOKPacket(int sequenceId, long affectedRows, long lastInsertId) {
        this(sequenceId, affectedRows, lastInsertId, DEFAULT_STATUS_FLAG, 0, "");
    }

    public MySQLOKPacket(MySQLPacketPayload payload) {
        this.sequenceId = payload.readInt1();
        Preconditions.checkArgument((0 == payload.readInt1() ? 1 : 0) != 0, (Object)"Header of MySQL OK packet must be `0x00`.");
        this.affectedRows = payload.readIntLenenc();
        this.lastInsertId = payload.readIntLenenc();
        this.statusFlag = payload.readInt2();
        this.warnings = payload.readInt2();
        this.info = payload.readStringEOF();
    }

    public void write(MySQLPacketPayload payload) {
        payload.writeInt1(0);
        payload.writeIntLenenc(this.affectedRows);
        payload.writeIntLenenc(this.lastInsertId);
        payload.writeInt2(this.statusFlag);
        payload.writeInt2(this.warnings);
        payload.writeStringEOF(this.info);
    }

    @Generated
    public MySQLOKPacket(int sequenceId, long affectedRows, long lastInsertId, int statusFlag, int warnings, String info) {
        this.sequenceId = sequenceId;
        this.affectedRows = affectedRows;
        this.lastInsertId = lastInsertId;
        this.statusFlag = statusFlag;
        this.warnings = warnings;
        this.info = info;
    }

    @Override
    @Generated
    public int getSequenceId() {
        return this.sequenceId;
    }

    @Generated
    public long getAffectedRows() {
        return this.affectedRows;
    }

    @Generated
    public long getLastInsertId() {
        return this.lastInsertId;
    }

    @Generated
    public int getStatusFlag() {
        return this.statusFlag;
    }

    @Generated
    public int getWarnings() {
        return this.warnings;
    }

    @Generated
    public String getInfo() {
        return this.info;
    }
}

