/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.MySQLPreparedStatement;

public final class MySQLPreparedStatementRegistry {
    private static final MySQLPreparedStatementRegistry INSTANCE = new MySQLPreparedStatementRegistry();
    private final ConcurrentMap<Integer, MySQLConnectionPreparedStatements> connectionRegistry = new ConcurrentHashMap<Integer, MySQLConnectionPreparedStatements>(8192, 1.0f);

    public static MySQLPreparedStatementRegistry getInstance() {
        return INSTANCE;
    }

    public void registerConnection(int connectionId) {
        this.connectionRegistry.put(connectionId, new MySQLConnectionPreparedStatements());
    }

    public MySQLConnectionPreparedStatements getConnectionPreparedStatements(int connectionId) {
        return (MySQLConnectionPreparedStatements)this.connectionRegistry.get(connectionId);
    }

    public void unregisterConnection(int connectionId) {
        this.connectionRegistry.remove(connectionId);
    }

    public static class MySQLConnectionPreparedStatements {
        private final Map<Integer, MySQLPreparedStatement> preparedStatements = new ConcurrentHashMap<Integer, MySQLPreparedStatement>(16384, 1.0f);
        private final AtomicInteger sequence = new AtomicInteger();

        public int prepareStatement(String sql, int parameterCount) {
            int result = this.sequence.incrementAndGet();
            this.preparedStatements.put(result, new MySQLPreparedStatement(sql, parameterCount));
            return result;
        }

        public MySQLPreparedStatement get(int statementId) {
            return this.preparedStatements.get(statementId);
        }

        public void closeStatement(int statementId) {
            this.preparedStatements.remove(statementId);
        }
    }
}

